/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.encoder;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import spring.turbo.convention.ExtraPasswordEncoderConvention;
import spring.turbo.core.SpringFactoriesUtils;
import spring.turbo.util.Asserts;
import spring.turbo.util.CollectionUtils;
import spring.turbo.util.StringUtils;

public final class PasswordEncoderFactories {
    private static final Logger log = LoggerFactory.getLogger(PasswordEncoderFactories.class);

    private PasswordEncoderFactories() {
    }

    public static BCryptPasswordEncoder createBCryptPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }

    public static DelegatingPasswordEncoder createDelegatingPasswordEncoder() {
        return PasswordEncoderFactories.createDelegatingPasswordEncoder("bcrypt", "noop");
    }

    public static DelegatingPasswordEncoder createDelegatingPasswordEncoder(String string) {
        return PasswordEncoderFactories.createDelegatingPasswordEncoder(string, "noop");
    }

    public static DelegatingPasswordEncoder createDelegatingPasswordEncoder(String string, @Nullable String string2) {
        Asserts.hasText((String)string);
        Map<String, PasswordEncoder> map = PasswordEncoderFactories.getEncoders();
        DelegatingPasswordEncoder delegatingPasswordEncoder = new DelegatingPasswordEncoder(string, map);
        log.info("supported encoder ids: [{}]", (Object)String.join((CharSequence)",", map.keySet()));
        if (StringUtils.isNotBlank((String)string2)) {
            delegatingPasswordEncoder.setDefaultPasswordEncoderForMatches(map.get(string2));
        }
        return delegatingPasswordEncoder;
    }

    private static Map<String, PasswordEncoder> getEncoders() {
        TreeMap treeMap = new TreeMap();
        List list = SpringFactoriesUtils.loadQuietly(ExtraPasswordEncoderConvention.class);
        for (ExtraPasswordEncoderConvention extraPasswordEncoderConvention : list) {
            try {
                CollectionUtils.nullSafeAddAll(treeMap, (Map)extraPasswordEncoderConvention.getExtraPasswordEncoderWithName());
            }
            catch (Throwable throwable) {}
        }
        return Collections.unmodifiableMap(treeMap);
    }
}

