/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.encoder;

import org.springframework.security.crypto.password.PasswordEncoder;
import spring.turbo.util.CharsetPool;
import spring.turbo.util.HexUtils;

public final class HEXPasswordEncoder
implements PasswordEncoder {
    private HEXPasswordEncoder() {
    }

    public static HEXPasswordEncoder getInstance() {
        return SyncAvoid.INSTANCE;
    }

    public String encode(CharSequence charSequence) {
        return new String(HexUtils.encode((byte[])charSequence.toString().getBytes(CharsetPool.UTF_8)));
    }

    public boolean matches(CharSequence charSequence, String string) {
        return this.encode(charSequence).equals(string);
    }

    private static class SyncAvoid {
        private static final HEXPasswordEncoder INSTANCE = new HEXPasswordEncoder();

        private SyncAvoid() {
        }
    }
}

