/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.convention;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.lang.Nullable;
import org.springframework.security.crypto.argon2.Argon2PasswordEncoder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.LdapShaPasswordEncoder;
import org.springframework.security.crypto.password.Md4PasswordEncoder;
import org.springframework.security.crypto.password.MessageDigestPasswordEncoder;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.crypto.scrypt.SCryptPasswordEncoder;
import spring.turbo.convention.ExtraPasswordEncoderConvention;
import spring.turbo.module.security.encoder.BrokenPasswordEncoder;
import spring.turbo.module.security.encoder.HEXPasswordEncoder;
import spring.turbo.util.InstanceUtils;

public final class ExtraPasswordEncoderConventionImpl
implements ExtraPasswordEncoderConvention {
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Map<String, PasswordEncoder> getExtraPasswordEncoderWithName() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("bcrypt", new BCryptPasswordEncoder());
        hashMap.put("noop", NoOpPasswordEncoder.getInstance());
        hashMap.put("ldap", new LdapShaPasswordEncoder());
        hashMap.put("MD4", new Md4PasswordEncoder());
        hashMap.put("MD5", new MessageDigestPasswordEncoder("MD5"));
        hashMap.put("SHA-1", new MessageDigestPasswordEncoder("SHA-1"));
        hashMap.put("SHA-256", new MessageDigestPasswordEncoder("SHA-256"));
        hashMap.put("pbkdf2", Pbkdf2PasswordEncoder.defaultsForSpringSecurity_v5_8());
        hashMap.put("scrypt", SCryptPasswordEncoder.defaultsForSpringSecurity_v5_8());
        hashMap.put("argon2", Argon2PasswordEncoder.defaultsForSpringSecurity_v5_8());
        hashMap.put("HEX", HEXPasswordEncoder.getInstance());
        hashMap.put("broken", BrokenPasswordEncoder.getInstance());
        PasswordEncoder passwordEncoder = this.getInstance("spring.turbo.module.security.encoder.hutool.MD2PasswordEncoder");
        if (passwordEncoder != null) {
            hashMap.put("MD2", passwordEncoder);
        }
        if ((passwordEncoder = this.getInstance("spring.turbo.module.security.encoder.hutool.SHA384PasswordEncoder")) != null) {
            hashMap.put("SHA-384", passwordEncoder);
        }
        if ((passwordEncoder = this.getInstance("spring.turbo.module.security.encoder.hutool.SHA512PasswordEncoder")) != null) {
            hashMap.put("SHA-512", passwordEncoder);
        }
        if ((passwordEncoder = this.getInstance("spring.turbo.module.security.encoder.hutool.SM3PasswordEncoder")) != null) {
            hashMap.put("SM3", passwordEncoder);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    @Nullable
    private PasswordEncoder getInstance(String string) {
        try {
            Optional optional = InstanceUtils.newInstance((String)string);
            return optional.orElse(null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

