/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.authentication.details;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import org.springframework.lang.Nullable;
import spring.turbo.module.security.authentication.details.AuthenticationDetails;
import spring.turbo.module.security.token.Token;
import spring.turbo.util.Asserts;
import spring.turbo.webmvc.RemoteAddressUtils;

public final class AuthenticationDetailsImpl
implements AuthenticationDetails {
    private final Date authenticatedTime;
    private final String path;
    @Nullable
    private final Token authenticatedToken;
    @Nullable
    private final String clientIp;

    public AuthenticationDetailsImpl(HttpServletRequest httpServletRequest, @Nullable Token token) {
        Asserts.notNull((Object)httpServletRequest);
        Asserts.notNull((Object)token);
        this.authenticatedTime = new Date();
        this.authenticatedToken = token;
        this.path = httpServletRequest.getRequestURI();
        this.clientIp = RemoteAddressUtils.getIpAddress((HttpServletRequest)httpServletRequest);
    }

    @Override
    public Date getAuthenticatedTime() {
        return this.authenticatedTime;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public Token getAuthenticatedToken() {
        return this.authenticatedToken;
    }

    @Override
    @Nullable
    public String getClientId() {
        return this.clientIp;
    }
}

