/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.authentication;

import java.util.Objects;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import spring.turbo.module.security.authentication.UserDetailsFinder;
import spring.turbo.util.Asserts;

public class UserDetailsServiceUserDetailsFinder
implements UserDetailsFinder {
    private final UserDetailsService userDetailsService;
    private final PasswordEncoder passwordEncoder;

    public UserDetailsServiceUserDetailsFinder(UserDetailsService userDetailsService) {
        this(userDetailsService, NoOpPasswordEncoder.getInstance());
    }

    public UserDetailsServiceUserDetailsFinder(UserDetailsService userDetailsService, @Nullable PasswordEncoder passwordEncoder) {
        Asserts.notNull((Object)userDetailsService);
        this.userDetailsService = userDetailsService;
        this.passwordEncoder = Objects.requireNonNullElseGet(passwordEncoder, NoOpPasswordEncoder::getInstance);
    }

    @Override
    @NonNull
    public UserDetails loadUserByUsername(String string) throws AuthenticationException {
        return this.userDetailsService.loadUserByUsername(string);
    }

    @Override
    @Nullable
    public UserDetails loadUserByUsernameAndPassword(String string, String string2) throws AuthenticationException {
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(string);
        if (userDetails == null || userDetails.getPassword() == null) {
            return null;
        }
        return this.passwordEncoder.matches((CharSequence)string2, userDetails.getPassword()) ? userDetails : null;
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }
}

