/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.authentication;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.lang.Nullable;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.web.context.request.ServletWebRequest;
import spring.turbo.module.security.authentication.details.AuthenticationDetailsImpl;
import spring.turbo.module.security.token.Token;
import spring.turbo.webmvc.HttpRequestSnapshot;

@FunctionalInterface
public interface RequestDetailsProvider {
    public static final RequestDetailsProvider ALWAYS_NULL = (httpServletRequest, token) -> null;
    public static final RequestDetailsProvider SPRING_SECURITY_DEFAULT = (httpServletRequest, token) -> new WebAuthenticationDetailsSource().buildDetails(httpServletRequest).toString();
    public static final RequestDetailsProvider SNAPSHOT = (httpServletRequest, token) -> HttpRequestSnapshot.of((HttpServletRequest)httpServletRequest).toString();
    public static final RequestDetailsProvider SIMPLE_DESCRIPTION = (httpServletRequest, token) -> new ServletWebRequest(httpServletRequest).getDescription(true);
    public static final RequestDetailsProvider AUTHENTICATION_DETAILS_OBJ = AuthenticationDetailsImpl::new;

    @Nullable
    public Object getDetails(HttpServletRequest var1, @Nullable Token var2);

    @Nullable
    default public Object getDetails(HttpServletRequest httpServletRequest) {
        return this.getDetails(httpServletRequest, null);
    }
}

