/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.authentication;

import org.springframework.lang.Nullable;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import spring.turbo.module.security.authentication.UserDetailsFinder;

public final class NullUserDetailsFinder
implements UserDetailsFinder {
    private NullUserDetailsFinder() {
    }

    public static NullUserDetailsFinder getInstance() {
        return SyncAvoid.INSTANCE;
    }

    @Override
    public UserDetails loadUserByUsername(String string) throws AuthenticationException {
        throw new UsernameNotFoundException(string);
    }

    @Override
    @Nullable
    public UserDetails loadUserByUsernameAndPassword(String string, String string2) throws AuthenticationException {
        return null;
    }

    private static class SyncAvoid {
        private static final NullUserDetailsFinder INSTANCE = new NullUserDetailsFinder();

        private SyncAvoid() {
        }
    }
}

