/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.authentication;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import spring.turbo.module.security.authentication.TokenToUserConverter;
import spring.turbo.module.security.token.StringToken;
import spring.turbo.module.security.token.Token;
import spring.turbo.util.CollectionUtils;

public class MapTokenToUserConverter
implements TokenToUserConverter {
    private final Map<String, UserDetails> tokenToUserMap = new HashMap<String, UserDetails>();

    public MapTokenToUserConverter() {
    }

    public MapTokenToUserConverter(String string, UserDetails userDetails) {
        this(Map.of(string, userDetails));
    }

    public MapTokenToUserConverter(Map<String, UserDetails> map) {
        CollectionUtils.nullSafeAddAll(this.tokenToUserMap, map);
    }

    public MapTokenToUserConverter add(String string, UserDetails userDetails) {
        this.tokenToUserMap.put(string, userDetails);
        return this;
    }

    @Override
    @Nullable
    public UserDetails convert(@Nullable Token token) throws AuthenticationException {
        if (this.tokenToUserMap.isEmpty()) {
            return null;
        }
        if (token instanceof StringToken) {
            StringToken stringToken = (StringToken)token;
            return this.tokenToUserMap.get(stringToken.asString());
        }
        return null;
    }

    public Map<String, UserDetails> getTokenToUserMap() {
        return Collections.unmodifiableMap(this.tokenToUserMap);
    }
}

