/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.security.authentication;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.userdetails.UserDetails;
import spring.turbo.module.security.token.Token;
import spring.turbo.module.security.util.AuthorityUtils;
import spring.turbo.util.Asserts;
import spring.turbo.util.collection.StringObjectMap;

public class Authentication
extends AbstractAuthenticationToken
implements org.springframework.security.core.Authentication {
    @Nullable
    private final UserDetails userDetails;
    @Nullable
    private final Token token;
    @Nullable
    private Map<String, Object> variables;

    public Authentication() {
        this(null, null);
    }

    public Authentication(@Nullable UserDetails userDetails) {
        this(userDetails, null);
    }

    public Authentication(@Nullable UserDetails userDetails, @Nullable Token token) {
        super(AuthorityUtils.getAuthorities(userDetails));
        this.userDetails = userDetails;
        this.token = token;
        super.setAuthenticated(userDetails != null);
        super.setDetails(null);
    }

    @NonNull
    public Object getPrincipal() {
        return Objects.requireNonNullElse(this.userDetails, Long.toString(System.identityHashCode((Object)this)));
    }

    @NonNull
    public Object getCredentials() {
        return Optional.ofNullable(this.userDetails).map(UserDetails::getPassword).orElse(Long.toString(System.identityHashCode((Object)this)));
    }

    @Nullable
    public UserDetails getUserDetails() {
        return this.userDetails;
    }

    public UserDetails getRequiredUserDetails() {
        UserDetails userDetails = this.getUserDetails();
        Asserts.notNull((Object)userDetails);
        return userDetails;
    }

    @Nullable
    public Token getToken() {
        return this.token;
    }

    public Token getRequiredToken() {
        Token token = this.getToken();
        Asserts.notNull((Object)token);
        return token;
    }

    @Nullable
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(@Nullable Map<String, Object> stringObjectMap) {
        this.variables = stringObjectMap != null ? stringObjectMap : StringObjectMap.newInstance();
    }

    public Map<String, Object> getRequiredVariables() {
        Map<String, Object> map = this.getVariables();
        Asserts.notNull(map);
        return map;
    }

    public void clearVariables() {
        this.setVariables(null);
    }
}

