/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *    ____             _            _____           _
 *   / ___| _ __  _ __(_)_ __   __ |_   _|   _ _ __| |__   ___
 *   \___ \| '_ \| '__| | '_ \ / _` || || | | | '__| '_ \ / _ \
 *    ___) | |_) | |  | | | | | (_| || || |_| | |  | |_) | (_) |
 *   |____/| .__/|_|  |_|_| |_|\__, ||_| \__,_|_|  |_.__/ \___/
 *         |_|                 |___/   https://github.com/yingzhuo/spring-turbo
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
package spring.turbo.module.security.encoder;

import org.springframework.lang.NonNull;
import org.springframework.security.crypto.password.PasswordEncoder;
import spring.turbo.bean.Named;

/**
 * @author 应卓
 * @see NamedPasswordEncoderProvider
 * @see spring.turbo.module.security.integration.NamedPasswordEncoderProviderImpl
 * @since 1.0.1
 */
public interface NamedPasswordEncoder extends PasswordEncoder, Named {

    public static NamedPasswordEncoder of(@NonNull String name, @NonNull PasswordEncoder passwordEncoder) {
        return new DelegatingNamedPasswordEncoder(name, passwordEncoder);
    }

    @NonNull
    @Override
    public String getName();

}
