/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.redis.util;

import java.util.Map;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.util.Assert;

public final class RedisUtils {
    private static final int DEFAULT_DELETE_ELEMENT_COUNT_PER_STEP = 100;

    private RedisUtils() {
    }

    public static <V> void deleteValuesByPattern(RedisOperations<String, V> redisOperations, String string) {
        RedisUtils.deleteValuesByPattern(redisOperations, string, 100);
    }

    public static <V> void deleteValuesByPattern(RedisOperations<String, V> redisOperations, String string, int n) {
        Assert.notNull(redisOperations, (String)"redisOperations is null");
        Assert.hasText((String)string, (String)"pattern is null or blank");
        Assert.isTrue((n >= 10 ? 1 : 0) != 0, (String)"deleteElementCountPerStep should >= 10");
        ScanOptions scanOptions = ScanOptions.scanOptions().match(string).count(100L).type(DataType.STRING).build();
        try (Cursor cursor = redisOperations.scan(scanOptions);){
            while (cursor.hasNext()) {
                String string2 = (String)cursor.next();
                redisOperations.delete((Object)string2);
            }
        }
    }

    public static <V> void deleteBigHash(RedisOperations<String, V> redisOperations, String string) {
        RedisUtils.deleteBigHash(redisOperations, string, 100);
    }

    public static <V> void deleteBigHash(RedisOperations<String, V> redisOperations, String string, int n) {
        Assert.notNull(redisOperations, (String)"redisOperations is null");
        Assert.hasText((String)string, (String)"key is null or blank");
        Assert.isTrue((n >= 10 ? 1 : 0) != 0, (String)"cursorCount should >= 10");
        HashOperations hashOperations = redisOperations.opsForHash();
        ScanOptions scanOptions = ScanOptions.scanOptions().count((long)n).match("*").build();
        try (Cursor cursor = hashOperations.scan((Object)string, scanOptions);){
            while (cursor.hasNext()) {
                Object k = ((Map.Entry)cursor.next()).getKey();
                hashOperations.delete((Object)string, new Object[]{k});
            }
        }
        redisOperations.delete((Object)string);
    }

    public static <V> void deleteBigList(RedisOperations<String, V> redisOperations, String string) {
        RedisUtils.deleteBigList(redisOperations, string, 100);
    }

    public static <V> void deleteBigList(RedisOperations<String, V> redisOperations, String string, int n) {
        Assert.notNull(redisOperations, (String)"redisOperations is null");
        Assert.notNull((Object)string, (String)"key is null or blank");
        Assert.isTrue((n >= 10 ? 1 : 0) != 0, (String)"deleteElementCountPerStep should >= 10");
        ListOperations listOperations = redisOperations.opsForList();
        Long l = listOperations.size((Object)string);
        if (l == null || l.equals(0L)) {
            return;
        }
        for (long i = 0L; i < l; i += (long)n) {
            listOperations.trim((Object)string, 0L, (long)n);
        }
        redisOperations.delete((Object)string);
    }

    public static <V> void deleteBigSet(RedisOperations<String, V> redisOperations, String string) {
        RedisUtils.deleteBigSet(redisOperations, string, 100);
    }

    public static <V> void deleteBigSet(RedisOperations<String, V> redisOperations, String string, int n) {
        Assert.notNull(redisOperations, (String)"redisOperations is null");
        Assert.hasText((String)string, (String)"key is null or blank");
        Assert.isTrue((n >= 10 ? 1 : 0) != 0, (String)"cursorCount should >= 10");
        SetOperations setOperations = redisOperations.opsForSet();
        ScanOptions scanOptions = ScanOptions.scanOptions().count((long)n).match("*").build();
        try (Cursor cursor = setOperations.scan((Object)string, scanOptions);){
            while (cursor.hasNext()) {
                Object object = cursor.next();
                setOperations.remove((Object)string, new Object[]{object});
            }
        }
        redisOperations.delete((Object)string);
    }

    public static <V> void deleteBigZset(RedisOperations<String, V> redisOperations, String string) {
        RedisUtils.deleteBigSet(redisOperations, string, 100);
    }

    public static <V> void deleteBigZset(RedisOperations<String, V> redisOperations, String string, int n) {
        Assert.notNull(redisOperations, (String)"redisOperations is null");
        Assert.hasText((String)string, (String)"key is null or blank");
        Assert.isTrue((n >= 10 ? 1 : 0) != 0, (String)"cursorCount should >= 10");
        ZSetOperations zSetOperations = redisOperations.opsForZSet();
        ScanOptions scanOptions = ScanOptions.scanOptions().count((long)n).match("*").build();
        try (Cursor cursor = zSetOperations.scan((Object)string, scanOptions);){
            while (cursor.hasNext()) {
                ZSetOperations.TypedTuple typedTuple = (ZSetOperations.TypedTuple)cursor.next();
                zSetOperations.remove((Object)string, new Object[]{typedTuple.getValue()});
            }
        }
        redisOperations.delete((Object)string);
    }
}

