/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.redis.lock;

import java.io.Serializable;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.module.redis.lock.LockFrame;
import spring.turbo.module.redis.lock.LockStack;
import spring.turbo.module.redis.lock.RenewTask;
import spring.turbo.util.concurrent.CurrentThreadUtils;

public final class DistributedReentrantLock
implements Serializable {
    private static final RedisScript<Long> TRY_LOCK = RedisScript.of((Resource)new ClassPathResource("META-INF/Lock#lock.lua"), Long.class);
    private static final RedisScript<Boolean> UNLOCK = RedisScript.of((Resource)new ClassPathResource("META-INF/Lock#unlock.lua"), Boolean.class);
    private final RedisOperations<String, String> redisOperations;
    private final LockStack lockStack;
    private final long ttlInSeconds;
    private final String lockKey;

    public DistributedReentrantLock(RedisOperations<String, String> redisOperations, String string, long l) {
        Assert.notNull(redisOperations, (String)"redisOperations is required");
        Assert.hasText((String)string, (String)"lockKey is required");
        Assert.isTrue((l > 0L ? 1 : 0) != 0, (String)"ttlInSeconds must greater than 0");
        this.redisOperations = redisOperations;
        this.lockKey = string;
        this.ttlInSeconds = l;
        this.lockStack = new LockStack();
    }

    public boolean tryLock() {
        long l = System.currentTimeMillis();
        String string = CurrentThreadUtils.getTrait();
        long l2 = (Long)this.redisOperations.execute(TRY_LOCK, List.of(), new Object[]{this.lockKey, string, String.valueOf(this.ttlInSeconds)});
        if (l2 >= 1L) {
            LockFrame lockFrame = new LockFrame(l, this.lockKey, string, this.ttlInSeconds, l2, CurrentThreadUtils.getId(), CurrentThreadUtils.getName());
            this.lockStack.push(lockFrame);
            return true;
        }
        return false;
    }

    public boolean unlock() {
        LockFrame lockFrame;
        String string = CurrentThreadUtils.getTrait();
        Boolean bl = (Boolean)this.redisOperations.execute(UNLOCK, List.of(), new Object[]{this.lockKey, string});
        if (bl.booleanValue() && (lockFrame = this.lockStack.peek()) != null && lockFrame.getLockField().equals(string)) {
            lockFrame.getNullableTimer().ifPresent(Timer::cancel);
            this.lockStack.pop();
        }
        return bl;
    }

    public void renewTtl() {
        Timer timer = new Timer(true);
        String string = CurrentThreadUtils.getTrait();
        timer.schedule((TimerTask)new RenewTask(this.redisOperations, this.lockKey, string, this.ttlInSeconds), this.ttlInSeconds * 1000L * 2L / 3L);
        LockFrame lockFrame = this.lockStack.peek();
        lockFrame.setTimer(timer);
    }

    @Nullable
    public LockFrame getCurrentFrame() {
        return this.lockStack.peek();
    }
}

