/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.redis.bloomfilter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.util.collection.CollectionUtils;
import spring.turbo.util.hash.BloomFilter;
import spring.turbo.util.hash.DigestHashFunction;
import spring.turbo.util.hash.HashFunction;

public class DistributedBloomFilter
implements BloomFilter {
    private static final int DEFAULT_BITMAP_SIZE = 1000000000;
    private final List<HashFunction> hashFunctions = new ArrayList<HashFunction>(5);
    private final RedisOperations<String, String> redisOperations;
    private final String redisKey;
    private final int bitmapSize;

    public DistributedBloomFilter(RedisOperations<String, String> redisOperations, String string) {
        this(redisOperations, string, 1000000000);
    }

    public DistributedBloomFilter(RedisOperations<String, String> redisOperations, String string, int n) {
        Assert.notNull(redisOperations, (String)"redisOperations is null");
        Assert.hasText((String)string, (String)"redisKey is null or empty");
        Assert.isTrue((n >= 10000000 ? 1 : 0) != 0, (String)"bitmapSize should >= 10000000");
        this.redisOperations = redisOperations;
        this.redisKey = string;
        this.bitmapSize = n;
    }

    public static DistributedBloomFilter createDefault(RedisOperations<String, String> redisOperations, String string) {
        return new DistributedBloomFilter(redisOperations, string, 1000000000).addHashFunctions(DigestHashFunction.md5(), DigestHashFunction.sha1(), DigestHashFunction.sha256(), DigestHashFunction.sha384(), DigestHashFunction.sha512());
    }

    public int getBitmapSize() {
        return this.bitmapSize;
    }

    public List<HashFunction> getHashFunctions() {
        return Collections.unmodifiableList(this.hashFunctions);
    }

    public DistributedBloomFilter addHashFunctions(HashFunction hashFunction, HashFunction ... hashFunctionArray) {
        CollectionUtils.nullSafeAdd(this.hashFunctions, (Object)hashFunction);
        CollectionUtils.nullSafeAddAll(this.hashFunctions, (Object[])hashFunctionArray);
        return this;
    }

    public void add(String string) {
        Assert.notNull((Object)string, (String)"element is null");
        Assert.notEmpty(this.hashFunctions, (String)"hashFunctions is empty");
        this.hashFunctions.forEach(hashFunction -> {
            int n = hashFunction.apply(string) % this.bitmapSize;
            n = Math.abs(n);
            this.redisOperations.opsForValue().setBit((Object)this.redisKey, (long)n, true);
        });
    }

    public boolean mightContain(@Nullable String string) {
        if (string == null) {
            return false;
        }
        Assert.notEmpty(this.hashFunctions, (String)"hashFunctions is empty");
        for (HashFunction hashFunction : this.hashFunctions) {
            int n = hashFunction.apply(string) % this.bitmapSize;
            n = Math.abs(n);
            Boolean bl = this.redisOperations.opsForValue().getBit((Object)this.redisKey, (long)n);
            if (bl.booleanValue()) continue;
            return false;
        }
        return true;
    }
}

