/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.redis.aspect;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.Ordered;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.util.Assert;
import spring.turbo.core.AspectSpELTemplate;
import spring.turbo.core.AspectUtils;
import spring.turbo.exception.RuntimeExceptionSupplier;
import spring.turbo.module.redis.aspect.AvoidRepeatedInvocation;

@Aspect
public class AvoidRepeatedInvocationAdvice
implements Ordered {
    private final RedisOperations<String, String> redisOperations;
    private final RuntimeExceptionSupplier exceptionSupplier;
    private final int order;

    public AvoidRepeatedInvocationAdvice(RedisOperations<String, String> redisOperations, RuntimeExceptionSupplier runtimeExceptionSupplier) {
        this(redisOperations, runtimeExceptionSupplier, Integer.MIN_VALUE);
    }

    public AvoidRepeatedInvocationAdvice(RedisOperations<String, String> redisOperations, RuntimeExceptionSupplier runtimeExceptionSupplier, int n) {
        Assert.notNull(redisOperations, (String)"redisOperations is required");
        Assert.notNull((Object)runtimeExceptionSupplier, (String)"exceptionSupplier is required");
        this.redisOperations = redisOperations;
        this.exceptionSupplier = runtimeExceptionSupplier;
        this.order = n;
    }

    @Around(value="@annotation(spring.turbo.module.redis.aspect.AvoidRepeatedInvocation)")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        AvoidRepeatedInvocation avoidRepeatedInvocation = (AvoidRepeatedInvocation)AspectUtils.getMethodAnnotation((JoinPoint)proceedingJoinPoint, AvoidRepeatedInvocation.class);
        if (avoidRepeatedInvocation == null) {
            return proceedingJoinPoint.proceed();
        }
        String string = (String)AspectSpELTemplate.newInstance((String)avoidRepeatedInvocation.value(), (ProceedingJoinPoint)proceedingJoinPoint).setRootObject(null).getValue();
        Boolean bl = this.redisOperations.opsForValue().setIfAbsent((Object)string, (Object)"1", avoidRepeatedInvocation.leaseTime(), avoidRepeatedInvocation.leaseTimeUnit());
        if (bl.booleanValue()) {
            return proceedingJoinPoint.proceed();
        }
        throw (RuntimeException)this.exceptionSupplier.get();
    }

    public int getOrder() {
        return this.order;
    }
}

