/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.rabbitmq.util;

import java.nio.charset.StandardCharsets;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import spring.turbo.util.Asserts;

public final class MessageFactories {
    private MessageFactories() {
    }

    public static Message create(String string) {
        return MessageFactories.create(string, Long.MIN_VALUE);
    }

    public static Message create(String string, long l) {
        return MessageFactories.create(string, l, Integer.MIN_VALUE);
    }

    public static Message create(String string, long l, int n) {
        Asserts.notNull((Object)string);
        MessageProperties messageProperties = new MessageProperties();
        messageProperties.setContentType("application/octet-stream");
        messageProperties.setDeliveryMode(MessageDeliveryMode.PERSISTENT);
        if (l > 0L) {
            messageProperties.setExpiration(Long.toString(l));
        }
        if (n >= 0) {
            messageProperties.setPriority(Integer.valueOf(n));
        }
        return new Message(string.getBytes(StandardCharsets.UTF_8), messageProperties);
    }
}

