/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.misc.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import org.springframework.lang.Nullable;
import spring.turbo.module.misc.qrcode.Logo;
import spring.turbo.module.misc.qrcode.QRCodeGenerator;

public class QRCodeGeneratorImpl
implements QRCodeGenerator {
    private static final String CHARSET = "UTF-8";
    private ErrorCorrectionLevel defaultErrorCorrectionLevel = ErrorCorrectionLevel.H;
    private int defaultSize = 200;
    private int defaultMargin = 1;

    @Override
    public BufferedImage generate(String string) {
        return this.generate(string, null);
    }

    @Override
    public BufferedImage generate(String string, @Nullable Logo logo) {
        return this.generate(string, logo, this.defaultErrorCorrectionLevel);
    }

    @Override
    public BufferedImage generate(String string, @Nullable Logo logo, @Nullable ErrorCorrectionLevel errorCorrectionLevel) {
        return this.generate(string, logo, errorCorrectionLevel, this.defaultSize);
    }

    @Override
    public BufferedImage generate(String string, @Nullable Logo logo, @Nullable ErrorCorrectionLevel errorCorrectionLevel, int n) {
        try {
            HashMap<EncodeHintType, Object> hashMap = new HashMap<EncodeHintType, Object>();
            hashMap.put(EncodeHintType.CHARACTER_SET, CHARSET);
            hashMap.put(EncodeHintType.ERROR_CORRECTION, errorCorrectionLevel != null ? errorCorrectionLevel : this.defaultErrorCorrectionLevel);
            hashMap.put(EncodeHintType.MARGIN, this.defaultMargin);
            int n2 = n >= 0 ? n : this.defaultSize;
            BitMatrix bitMatrix = new MultiFormatWriter().encode(string, BarcodeFormat.QR_CODE, n2, n2, hashMap);
            int n3 = bitMatrix.getWidth();
            int n4 = bitMatrix.getHeight();
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 1);
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    bufferedImage.setRGB(i, j, bitMatrix.get(i, j) ? -16777216 : -1);
                }
            }
            if (logo != null) {
                this.insertLogo(bufferedImage, logo, n2);
            }
            return bufferedImage;
        }
        catch (WriterException writerException) {
            throw new UncheckedIOException(writerException.getMessage(), new IOException(writerException));
        }
    }

    private void insertLogo(BufferedImage bufferedImage, Logo logo, int n) {
        Object object;
        Object object2 = logo.getImage();
        int n2 = ((Image)object2).getWidth(null);
        int n3 = ((Image)object2).getHeight(null);
        if (logo.isCompress()) {
            if (n2 > 60) {
                n2 = 60;
            }
            if (n3 > 60) {
                n3 = 60;
            }
            object = ((Image)object2).getScaledInstance(n2, n3, 4);
            BufferedImage bufferedImage2 = new BufferedImage(n2, n3, 1);
            Graphics graphics = bufferedImage2.getGraphics();
            graphics.drawImage((Image)object, 0, 0, null);
            graphics.dispose();
            object2 = object;
        }
        object = bufferedImage.createGraphics();
        int n4 = (n - n2) / 2;
        int n5 = (n - n3) / 2;
        ((Graphics)object).drawImage((Image)object2, n4, n5, n2, n3, null);
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n4, n5, n2, n2, 6.0f, 6.0f);
        ((Graphics2D)object).setStroke(new BasicStroke(3.0f));
        ((Graphics2D)object).draw(float_);
        ((Graphics)object).dispose();
    }

    public void setDefaultErrorCorrectionLevel(ErrorCorrectionLevel errorCorrectionLevel) {
        this.defaultErrorCorrectionLevel = errorCorrectionLevel;
    }

    public void setDefaultSize(int n) {
        this.defaultSize = n;
    }

    public void setDefaultMargin(int n) {
        this.defaultMargin = n;
    }
}

