/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.misc.qrcode;

import jakarta.annotation.Nullable;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import org.springframework.core.io.Resource;
import spring.turbo.io.IOExceptionUtils;
import spring.turbo.util.Asserts;

public final class Logo
implements Serializable {
    @Nullable
    private Image image;
    private boolean compress = true;

    private Logo() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public Image getImage() {
        Asserts.notNull((Object)this.image);
        return this.image;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public static class Builder
    implements spring.turbo.bean.Builder<Logo> {
        @Nullable
        private Image image;
        private boolean compress = true;

        private Builder() {
        }

        public Builder image(Image image) {
            this.image = image;
            return this;
        }

        public Builder image(Resource resource) {
            try {
                return this.image(resource.getFile());
            }
            catch (IOException iOException) {
                throw IOExceptionUtils.toUnchecked((IOException)iOException);
            }
        }

        public Builder image(InputStream inputStream) {
            try {
                this.image = ImageIO.read(inputStream);
                return this;
            }
            catch (IOException iOException) {
                throw IOExceptionUtils.toUnchecked((IOException)iOException);
            }
        }

        public Builder image(ImageInputStream imageInputStream) {
            try {
                this.image = ImageIO.read(imageInputStream);
                return this;
            }
            catch (IOException iOException) {
                throw IOExceptionUtils.toUnchecked((IOException)iOException);
            }
        }

        public Builder image(File file) {
            try {
                this.image = ImageIO.read(file);
                return this;
            }
            catch (IOException iOException) {
                throw IOExceptionUtils.toUnchecked((IOException)iOException);
            }
        }

        public Builder compress(boolean bl) {
            this.compress = bl;
            return this;
        }

        public Logo build() {
            Asserts.notNull((Object)this.image);
            Logo logo = new Logo();
            logo.image = Objects.requireNonNull(this.image);
            logo.compress = this.compress;
            return logo;
        }
    }
}

