/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.misc.pdf;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import spring.turbo.util.Asserts;

public class WatermarkPositions
implements Iterable<Position> {
    private final List<Position> list;
    public static final WatermarkPositions DEFAULT = WatermarkPositions.builder().add(300, 250, 30).add(300, 450, 30).add(300, 650, 30).build();

    private WatermarkPositions(List<Position> list) {
        this.list = list;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Iterator<Position> iterator() {
        return this.list.listIterator();
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    static class Builder
    implements spring.turbo.bean.Builder<WatermarkPositions> {
        private final List<Position> list = new LinkedList<Position>();

        private Builder() {
        }

        public Builder add(int n, int n2, int n3) {
            this.list.add(new Position(n, n2, n3));
            return this;
        }

        public Builder clear() {
            this.list.clear();
            return this;
        }

        public WatermarkPositions build() {
            return this.list.isEmpty() ? DEFAULT : new WatermarkPositions(this.list);
        }
    }

    public static class Position {
        private final int x;
        private final int y;
        private final int rotation;

        public Position(int n, int n2, int n3) {
            Asserts.isTrue((n >= 0 ? 1 : 0) != 0);
            Asserts.isTrue((n2 >= 0 ? 1 : 0) != 0);
            Asserts.isTrue((n3 >= 0 ? 1 : 0) != 0);
            this.x = n;
            this.y = n2;
            this.rotation = n3;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getRotation() {
            return this.rotation;
        }
    }
}

