/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.misc.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import spring.turbo.io.IOExceptionUtils;
import spring.turbo.io.LocalFileDescriptor;
import spring.turbo.module.misc.pdf.WatermarkGenerator;
import spring.turbo.module.misc.pdf.WatermarkPositions;

public class WatermarkGeneratorImpl
implements WatermarkGenerator {
    private String watermarkFontName = "STSong-Light";
    private int watermarkFontSize = 56;
    private String watermarkFontEncoding = "UniGB-UCS2-H";
    private boolean watermarkFontEmbedded = false;
    private float watermarkFontOpacity = 0.4f;
    private WatermarkPositions watermarkPositions = WatermarkPositions.DEFAULT;

    public void setWatermarkFontName(String string) {
        this.watermarkFontName = string;
    }

    public void setWatermarkFontSize(int n) {
        this.watermarkFontSize = n;
    }

    public void setWatermarkFontEncoding(String string) {
        this.watermarkFontEncoding = string;
    }

    public void setWatermarkFontEmbedded(boolean bl) {
        this.watermarkFontEmbedded = bl;
    }

    public void setWatermarkFontOpacity(float f) {
        this.watermarkFontOpacity = f;
    }

    public void setWatermarkPositions(WatermarkPositions watermarkPositions) {
        this.watermarkPositions = watermarkPositions;
    }

    @Override
    public void addWatermark(LocalFileDescriptor localFileDescriptor, LocalFileDescriptor localFileDescriptor2, Object object) {
        try {
            PdfReader pdfReader = new PdfReader(localFileDescriptor.openAsInputStream());
            PdfStamper pdfStamper = new PdfStamper(pdfReader, localFileDescriptor2.openAsOutputStream(false));
            PdfGState pdfGState = new PdfGState();
            BaseFont baseFont = BaseFont.createFont((String)this.watermarkFontName, (String)this.watermarkFontEncoding, (boolean)this.watermarkFontEmbedded);
            pdfGState.setFillOpacity(this.watermarkFontOpacity);
            int n = pdfReader.getNumberOfPages() + 1;
            for (WatermarkPositions.Position position : this.watermarkPositions) {
                for (int i = 1; i < n; ++i) {
                    PdfContentByte pdfContentByte = pdfStamper.getOverContent(i);
                    pdfContentByte.beginText();
                    pdfContentByte.setGState(pdfGState);
                    pdfContentByte.setColorFill(BaseColor.DARK_GRAY);
                    pdfContentByte.setFontAndSize(baseFont, (float)this.watermarkFontSize);
                    pdfContentByte.showTextAligned(1, object.toString(), (float)position.getX(), (float)position.getY(), (float)position.getRotation());
                    pdfContentByte.endText();
                }
            }
            pdfStamper.close();
        }
        catch (Exception exception) {
            throw IOExceptionUtils.toUnchecked((String)exception.getMessage());
        }
    }
}

