/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.misc.javassist;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import spring.turbo.bean.Pair;
import spring.turbo.bean.Tuple;
import spring.turbo.module.misc.javassist.AnnotationDescriptor;
import spring.turbo.module.misc.javassist.AnnotationDescriptorHelper;
import spring.turbo.module.misc.javassist.ClassCache;
import spring.turbo.module.misc.javassist.PojoDescriptor;
import spring.turbo.module.misc.javassist.PojoTypeGenerator;
import spring.turbo.module.misc.javassist.UnableToCompileException;
import spring.turbo.module.misc.javassist.UnableToFindException;
import spring.turbo.util.Asserts;
import spring.turbo.util.CollectionUtils;

public class PojoTypeGeneratorImpl
implements PojoTypeGenerator {
    private final ClassCache classCache = new ClassCache();

    @Override
    public Class<?> generate(PojoDescriptor pojoDescriptor) {
        Asserts.notNull((Object)pojoDescriptor);
        try {
            return this.doGenerate(pojoDescriptor);
        }
        catch (NotFoundException notFoundException) {
            throw new UnableToFindException(notFoundException.getMessage(), notFoundException);
        }
        catch (CannotCompileException cannotCompileException) {
            throw new UnableToCompileException(cannotCompileException.getMessage(), cannotCompileException);
        }
    }

    private Class<?> doGenerate(PojoDescriptor pojoDescriptor) throws NotFoundException, CannotCompileException {
        String string = pojoDescriptor.getPojoFqn();
        Class<?> clazz = this.classCache.find(string);
        if (clazz != null) {
            return clazz;
        }
        ClassPool classPool = ClassPool.getDefault();
        CtClass ctClass = classPool.makeClass(string);
        ClassFile classFile = ctClass.getClassFile();
        ConstPool constPool = classFile.getConstPool();
        ctClass.addInterface(this.resolveCtClass(Serializable.class));
        List<AnnotationDescriptor> list = pojoDescriptor.getClassLevelAnnotations();
        if (CollectionUtils.isNotEmpty(list)) {
            for (AnnotationDescriptor object : list) {
                AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
                Annotation annotation = new Annotation(object.getAnnotationFqn(), constPool);
                if (CollectionUtils.isNotEmpty(object.getValues())) {
                    for (AnnotationDescriptor.AnnotationValue annotationValue : object.getValues()) {
                        annotation.addMemberValue(annotationValue.getName(), AnnotationDescriptorHelper.createMemberValue(annotationValue, constPool));
                    }
                }
                annotationsAttribute.addAnnotation(annotation);
                classFile.addAttribute((AttributeInfo)annotationsAttribute);
            }
        }
        for (Map.Entry entry : pojoDescriptor.entrySet()) {
            ctClass.addField(this.generateField(ctClass, (String)entry.getKey(), (Class)entry.getValue(), constPool, this.findAnnotations((String)entry.getKey(), PojoDescriptor.AnnotationPos.FIELD, pojoDescriptor)));
            ctClass.addMethod(this.generateGetter(ctClass, (String)entry.getKey(), (Class)entry.getValue(), constPool, this.findAnnotations((String)entry.getKey(), PojoDescriptor.AnnotationPos.GETTER, pojoDescriptor)));
            ctClass.addMethod(this.generateSetter(ctClass, (String)entry.getKey(), (Class)entry.getValue(), constPool, this.findAnnotations((String)entry.getKey(), PojoDescriptor.AnnotationPos.SETTER, pojoDescriptor)));
        }
        Class clazz2 = ctClass.toClass();
        this.classCache.set(clazz2);
        return clazz2;
    }

    private CtField generateField(CtClass ctClass, String string, Class<?> clazz, ConstPool constPool, AnnotationDescriptor ... annotationDescriptorArray) throws NotFoundException, CannotCompileException {
        CtField ctField = new CtField(this.resolveCtClass(clazz), string, ctClass);
        FieldInfo fieldInfo = ctField.getFieldInfo();
        for (AnnotationDescriptor annotationDescriptor : annotationDescriptorArray) {
            AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
            Annotation annotation = new Annotation(annotationDescriptor.getAnnotationFqn(), constPool);
            if (CollectionUtils.isNotEmpty(annotationDescriptor.getValues())) {
                for (AnnotationDescriptor.AnnotationValue annotationValue : annotationDescriptor.getValues()) {
                    annotation.addMemberValue(annotationValue.getName(), AnnotationDescriptorHelper.createMemberValue(annotationValue, constPool));
                }
            }
            annotationsAttribute.addAnnotation(annotation);
            fieldInfo.addAttribute((AttributeInfo)annotationsAttribute);
        }
        return ctField;
    }

    private CtMethod generateGetter(CtClass ctClass, String string, Class<?> clazz, ConstPool constPool, AnnotationDescriptor ... annotationDescriptorArray) throws CannotCompileException {
        String string2 = "get" + string.substring(0, 1).toUpperCase() + string.substring(1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("public ").append(clazz.getName()).append(" ").append(string2).append("(){").append("return this.").append(string).append(";").append("}");
        CtMethod ctMethod = CtMethod.make((String)stringBuilder.toString(), (CtClass)ctClass);
        MethodInfo methodInfo = ctMethod.getMethodInfo();
        for (AnnotationDescriptor annotationDescriptor : annotationDescriptorArray) {
            AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
            Annotation annotation = new Annotation(annotationDescriptor.getAnnotationFqn(), constPool);
            if (CollectionUtils.isNotEmpty(annotationDescriptor.getValues())) {
                for (AnnotationDescriptor.AnnotationValue annotationValue : annotationDescriptor.getValues()) {
                    annotation.addMemberValue(annotationValue.getName(), AnnotationDescriptorHelper.createMemberValue(annotationValue, constPool));
                }
            }
            annotationsAttribute.addAnnotation(annotation);
            methodInfo.addAttribute((AttributeInfo)annotationsAttribute);
        }
        return ctMethod;
    }

    private CtMethod generateSetter(CtClass ctClass, String string, Class<?> clazz, ConstPool constPool, AnnotationDescriptor ... annotationDescriptorArray) throws CannotCompileException {
        String string2 = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("public void ").append(string2).append("(").append(clazz.getName()).append(" ").append(string).append(")").append("{").append("this.").append(string).append("=").append(string).append(";").append("}");
        CtMethod ctMethod = CtMethod.make((String)stringBuilder.toString(), (CtClass)ctClass);
        MethodInfo methodInfo = ctMethod.getMethodInfo();
        for (AnnotationDescriptor annotationDescriptor : annotationDescriptorArray) {
            AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
            Annotation annotation = new Annotation(annotationDescriptor.getAnnotationFqn(), constPool);
            if (CollectionUtils.isNotEmpty(annotationDescriptor.getValues())) {
                for (AnnotationDescriptor.AnnotationValue annotationValue : annotationDescriptor.getValues()) {
                    annotation.addMemberValue(annotationValue.getName(), AnnotationDescriptorHelper.createMemberValue(annotationValue, constPool));
                }
            }
            annotationsAttribute.addAnnotation(annotation);
            methodInfo.addAttribute((AttributeInfo)annotationsAttribute);
        }
        return ctMethod;
    }

    private CtClass resolveCtClass(Class<?> clazz) throws NotFoundException {
        ClassPool classPool = ClassPool.getDefault();
        return classPool.get(clazz.getName());
    }

    private AnnotationDescriptor[] findAnnotations(String string, PojoDescriptor.AnnotationPos annotationPos, PojoDescriptor pojoDescriptor) {
        ArrayList arrayList = new ArrayList();
        for (Pair<PojoDescriptor.AnnotationPos, List<AnnotationDescriptor>> tuple : pojoDescriptor.getAllPropertyAnnotationConfig()) {
            if (tuple.getA() != annotationPos) continue;
            CollectionUtils.nullSafeAddAll(arrayList, (Collection)((Collection)tuple.getB()));
        }
        for (Tuple tuple : pojoDescriptor.getPropertyAnnotationConfig()) {
            if (tuple.getB() != annotationPos || !string.equals(tuple.getA())) continue;
            CollectionUtils.nullSafeAddAll(arrayList, (Collection)((Collection)tuple.getC()));
        }
        return arrayList.toArray(new AnnotationDescriptor[0]);
    }
}

