/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.misc.javassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.springframework.lang.Nullable;
import org.springframework.util.comparator.ComparableComparator;
import spring.turbo.bean.Pair;
import spring.turbo.bean.Tuple;
import spring.turbo.module.misc.javassist.AnnotationDescriptor;
import spring.turbo.util.Asserts;
import spring.turbo.util.CollectionUtils;

public class PojoDescriptor
extends TreeMap<String, Class<?>>
implements Map<String, Class<?>> {
    private static final Comparator<String> DEFAULT_PROPERTY_COMPARATOR = new ComparableComparator();
    private final String pojoFqn;
    private final List<AnnotationDescriptor> classLevelAnnotations = new ArrayList<AnnotationDescriptor>();
    private final List<Pair<AnnotationPos, List<AnnotationDescriptor>>> allPropertyAnnotationConfig = new ArrayList<Pair<AnnotationPos, List<AnnotationDescriptor>>>();
    private final List<Tuple<String, AnnotationPos, List<AnnotationDescriptor>>> propertyAnnotationConfig = new ArrayList<Tuple<String, AnnotationPos, List<AnnotationDescriptor>>>();
    private final Comparator<String> propertyComparator;

    private PojoDescriptor(String string, @Nullable Comparator<String> comparator) {
        super(Optional.ofNullable(comparator).orElse(DEFAULT_PROPERTY_COMPARATOR));
        Asserts.notNull((Object)string);
        this.pojoFqn = string;
        this.propertyComparator = Optional.ofNullable(comparator).orElse(DEFAULT_PROPERTY_COMPARATOR);
    }

    public static PojoDescriptor newInstance(String string) {
        return PojoDescriptor.newInstance(string, null);
    }

    public static PojoDescriptor newInstance(String string, @Nullable Comparator<String> comparator) {
        return new PojoDescriptor(string, comparator);
    }

    public static PojoDescriptor fromMap(String string, Map map) {
        return PojoDescriptor.fromMap(string, map, null);
    }

    public static PojoDescriptor fromMap(String string, Map map, @Nullable Comparator<String> comparator) {
        Asserts.notNull((Object)map);
        PojoDescriptor pojoDescriptor = PojoDescriptor.newInstance(string, comparator);
        for (Object k : map.keySet()) {
            if (!(k instanceof CharSequence)) {
                throw new IllegalArgumentException("Unsupported key type.");
            }
            String string2 = k.toString();
            Object v = map.get(k);
            if (v == null) continue;
            pojoDescriptor = pojoDescriptor.add(string2, v.getClass());
        }
        return pojoDescriptor;
    }

    public PojoDescriptor add(String string, Class clazz) {
        this.put(string, clazz);
        return this;
    }

    public PojoDescriptor addClassLevelAnnotations(AnnotationDescriptor ... annotationDescriptorArray) {
        CollectionUtils.nullSafeAddAll(this.classLevelAnnotations, (Object[])annotationDescriptorArray);
        return this;
    }

    public PojoDescriptor addPropertyLevelAnnotationsForAllProperties(AnnotationPos annotationPos, AnnotationDescriptor ... annotationDescriptorArray) {
        Asserts.notNull((Object)((Object)annotationPos));
        Asserts.notEmpty((Object[])annotationDescriptorArray);
        this.allPropertyAnnotationConfig.add((Pair<AnnotationPos, List<AnnotationDescriptor>>)Pair.ofNonNull((Object)((Object)annotationPos), Arrays.asList(annotationDescriptorArray)));
        return this;
    }

    public PojoDescriptor addPropertyLevelAnnotations(String string, AnnotationPos annotationPos, AnnotationDescriptor ... annotationDescriptorArray) {
        Asserts.notNull((Object)string);
        Asserts.notNull((Object)((Object)annotationPos));
        Asserts.notEmpty((Object[])annotationDescriptorArray);
        this.propertyAnnotationConfig.add((Tuple<String, AnnotationPos, List<AnnotationDescriptor>>)Tuple.ofNonNull((Object)string, (Object)((Object)annotationPos), Arrays.asList(annotationDescriptorArray)));
        return this;
    }

    @Override
    public String toString() {
        return this.pojoFqn;
    }

    public String getPojoFqn() {
        return this.pojoFqn;
    }

    public List<AnnotationDescriptor> getClassLevelAnnotations() {
        return this.classLevelAnnotations;
    }

    public List<Pair<AnnotationPos, List<AnnotationDescriptor>>> getAllPropertyAnnotationConfig() {
        return this.allPropertyAnnotationConfig;
    }

    public List<Tuple<String, AnnotationPos, List<AnnotationDescriptor>>> getPropertyAnnotationConfig() {
        return this.propertyAnnotationConfig;
    }

    public Comparator<String> getPropertyComparator() {
        return this.propertyComparator;
    }

    public static enum AnnotationPos {
        GETTER,
        SETTER,
        FIELD;

    }
}

