/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.misc.javassist;

import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import spring.turbo.module.misc.javassist.AnnotationDescriptor;
import spring.turbo.util.Asserts;

public final class AnnotationDescriptorHelper {
    private AnnotationDescriptorHelper() {
    }

    public static MemberValue createMemberValue(AnnotationDescriptor.AnnotationValue annotationValue, ConstPool constPool) {
        Asserts.notNull((Object)annotationValue);
        Object object = annotationValue.getValue();
        Class<?> clazz = object.getClass();
        if (object instanceof Class) {
            return new ClassMemberValue(((Class)object).getName(), constPool);
        }
        if (clazz == String.class) {
            return new StringMemberValue((String)object, constPool);
        }
        if (clazz == Integer.class) {
            return new IntegerMemberValue(constPool, ((Integer)object).intValue());
        }
        if (clazz == Long.class) {
            return new LongMemberValue(((Long)object).longValue(), constPool);
        }
        if (clazz == Double.class) {
            return new DoubleMemberValue(((Double)object).doubleValue(), constPool);
        }
        if (clazz == Float.class) {
            return new FloatMemberValue(((Float)object).floatValue(), constPool);
        }
        if (clazz == Short.class) {
            return new ShortMemberValue(((Short)object).shortValue(), constPool);
        }
        if (clazz == Byte.class) {
            return new ByteMemberValue(((Byte)object).byteValue(), constPool);
        }
        if (clazz == Character.class) {
            return new CharMemberValue(((Character)object).charValue(), constPool);
        }
        if (clazz.isEnum()) {
            EnumMemberValue enumMemberValue = new EnumMemberValue(constPool);
            enumMemberValue.setType(clazz.getName());
            enumMemberValue.setValue(object.toString());
            return enumMemberValue;
        }
        throw new UnsupportedOperationException("Not supported yet, sorry!");
    }
}

