/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.misc.javassist;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.lang.Nullable;
import spring.turbo.util.Asserts;

public final class AnnotationDescriptor
implements Serializable {
    private final String annotationFqn;
    private final List<AnnotationValue> values;

    private AnnotationDescriptor(String string, @Nullable List<AnnotationValue> list) {
        Asserts.notNull((Object)string);
        this.annotationFqn = string;
        this.values = list != null ? list : Collections.emptyList();
    }

    public static Builder builder(Class<? extends Annotation> clazz) {
        Asserts.notNull(clazz);
        return new Builder(clazz.getName());
    }

    public static Builder builder(String string) {
        Asserts.notNull((Object)string);
        return new Builder(string);
    }

    public String getAnnotationFqn() {
        return this.annotationFqn;
    }

    public List<AnnotationValue> getValues() {
        return this.values;
    }

    public static final class Builder {
        private final List<AnnotationValue> annotationValues = new ArrayList<AnnotationValue>(0);
        private final String annotationFqn;

        private Builder(String string) {
            this.annotationFqn = string;
        }

        public Builder addValue(String string, Object object) {
            this.annotationValues.add(new AnnotationValue(string, object));
            return this;
        }

        public AnnotationDescriptor build() {
            Asserts.notNull((Object)this.annotationFqn);
            return new AnnotationDescriptor(this.annotationFqn, this.annotationValues);
        }
    }

    public static final class AnnotationValue
    implements Serializable {
        private final String name;
        private final Object value;

        public AnnotationValue(String string, Object object) {
            Asserts.notNull((Object)string);
            Asserts.notNull((Object)object);
            this.name = string;
            this.value = object;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

