/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.misc.captcha.support;

import java.time.Duration;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.lang.Nullable;
import spring.turbo.module.misc.captcha.support.CaptchaDao;
import spring.turbo.util.Asserts;

public class RedisCaptchaDao
implements CaptchaDao {
    private final StringRedisTemplate redisTemplate;

    public RedisCaptchaDao(StringRedisTemplate stringRedisTemplate) {
        Asserts.notNull((Object)stringRedisTemplate);
        this.redisTemplate = stringRedisTemplate;
    }

    @Override
    public void save(String string, String string2, @Nullable Duration duration) {
        Asserts.hasText((String)string);
        Asserts.hasText((String)string2);
        if (duration == null) {
            this.redisTemplate.opsForValue().set((Object)string, (Object)string2);
        } else {
            this.redisTemplate.opsForValue().set((Object)string, (Object)string2, duration);
        }
    }

    @Override
    public String find(String string) {
        Asserts.hasText((String)string);
        return (String)this.redisTemplate.opsForValue().get((Object)string);
    }

    @Override
    public void delete(String string) {
        Asserts.hasText((String)string);
        this.redisTemplate.delete((Object)string);
    }
}

