/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.misc.captcha.hutool;

import cn.hutool.captcha.ICaptcha;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import javax.imageio.ImageIO;
import org.springframework.lang.NonNull;
import spring.turbo.io.CloseUtils;
import spring.turbo.module.misc.captcha.Captcha;
import spring.turbo.module.misc.captcha.CaptchaService;

public abstract class AbstractHutoolCaptchaService
implements CaptchaService {
    @Override
    public final Captcha create() {
        ICaptcha iCaptcha = this.createCaptcha();
        return new Captcha(iCaptcha.getCode(), this.toBufferedImage(iCaptcha));
    }

    private BufferedImage toBufferedImage(ICaptcha iCaptcha) {
        BufferedImage bufferedImage;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            iCaptcha.write((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            bufferedImage = ImageIO.read(byteArrayInputStream);
        }
        catch (IOException iOException) {
            try {
                throw new UncheckedIOException(iOException);
            }
            catch (Throwable throwable) {
                CloseUtils.closeQuietly(byteArrayInputStream);
                CloseUtils.closeQuietly((Closeable)byteArrayOutputStream);
                throw throwable;
            }
        }
        CloseUtils.closeQuietly((Closeable)byteArrayInputStream);
        CloseUtils.closeQuietly((Closeable)byteArrayOutputStream);
        return bufferedImage;
    }

    @NonNull
    protected abstract ICaptcha createCaptcha();
}

