/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.misc.captcha.google.renderer;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import spring.turbo.module.misc.captcha.google.color.ColorFactory;
import spring.turbo.module.misc.captcha.google.font.FontFactory;
import spring.turbo.module.misc.captcha.google.renderer.TextCharacter;
import spring.turbo.module.misc.captcha.google.renderer.TextRenderer;
import spring.turbo.module.misc.captcha.google.renderer.TextString;

public abstract class AbstractTextRenderer
implements TextRenderer {
    protected int leftMargin = 5;
    protected int rightMargin = 5;
    protected int topMargin = 5;
    protected int bottomMargin = 5;

    protected abstract void arrangeCharacters(int var1, int var2, TextString var3);

    @Override
    public void setLeftMargin(int n) {
        this.leftMargin = n;
    }

    @Override
    public void setRightMargin(int n) {
        this.rightMargin = n;
    }

    @Override
    public void setTopMargin(int n) {
        this.topMargin = n;
    }

    @Override
    public void setBottomMargin(int n) {
        this.bottomMargin = n;
    }

    @Override
    public void draw(String string, BufferedImage bufferedImage, FontFactory fontFactory, ColorFactory colorFactory) {
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        TextString textString = this.convertToCharacters(string, graphics2D, fontFactory, colorFactory);
        this.arrangeCharacters(bufferedImage.getWidth(), bufferedImage.getHeight(), textString);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        for (TextCharacter textCharacter : textString.getCharacters()) {
            graphics2D.setColor(textCharacter.getColor());
            graphics2D.drawString(textCharacter.iterator(), (float)textCharacter.getX(), (float)textCharacter.getY());
        }
    }

    protected TextString convertToCharacters(String string, Graphics2D graphics2D, FontFactory fontFactory, ColorFactory colorFactory) {
        TextString textString = new TextString();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = 0.0;
        for (int i = 0; i < string.length(); ++i) {
            Font font = fontFactory.getFont(i);
            char c = string.charAt(i);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            Rectangle2D rectangle2D = font.getStringBounds(String.valueOf(c), fontRenderContext);
            TextCharacter textCharacter = new TextCharacter();
            textCharacter.setCharacter(c);
            textCharacter.setFont(font);
            textCharacter.setWidth(fontMetrics.charWidth(c));
            textCharacter.setHeight(fontMetrics.getAscent() + fontMetrics.getDescent());
            textCharacter.setAscent(fontMetrics.getAscent());
            textCharacter.setDescent(fontMetrics.getDescent());
            textCharacter.setX(d);
            textCharacter.setY(0.0);
            textCharacter.setFont(font);
            textCharacter.setColor(colorFactory.getColor(i));
            d += rectangle2D.getWidth();
            textString.addCharacter(textCharacter);
        }
        return textString;
    }
}

