/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.misc.captcha.google.font;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import spring.turbo.module.misc.captcha.google.font.FontFactory;

public class RandomFontFactory
implements FontFactory {
    protected List<String> families = new ArrayList<String>();
    protected int minSize;
    protected int maxSize;
    protected boolean randomStyle;

    public RandomFontFactory() {
        this.families.add("Verdana");
        this.families.add("Tahoma");
        this.minSize = 45;
        this.maxSize = 45;
    }

    public RandomFontFactory(List<String> list) {
        this();
        this.families = list;
    }

    public RandomFontFactory(String[] stringArray) {
        this();
        this.families = Arrays.asList(stringArray);
    }

    public RandomFontFactory(int n, List<String> list) {
        this(list);
        this.minSize = this.maxSize = n;
    }

    public RandomFontFactory(int n, String[] stringArray) {
        this(stringArray);
        this.minSize = this.maxSize = n;
    }

    public void setFamilies(List<String> list) {
        this.families = list;
    }

    public void setMinSize(int n) {
        this.minSize = n;
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    public void setRandomStyle(boolean bl) {
        this.randomStyle = bl;
    }

    @Override
    public Font getFont(int n) {
        Random random = new Random();
        String string = this.families.get(random.nextInt(this.families.size()));
        boolean bl = random.nextBoolean() && this.randomStyle;
        int n2 = this.minSize;
        if (this.maxSize - this.minSize > 0) {
            n2 += random.nextInt(this.maxSize - this.minSize);
        }
        return new Font(string, bl ? 1 : 0, n2);
    }
}

