/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.misc.captcha.google.filter.lib;

import spring.turbo.module.misc.captcha.google.filter.lib.AbstractTransformImageOp;
import spring.turbo.module.misc.captcha.google.filter.lib.PerlinNoise;

public class MarbleImageOp
extends AbstractTransformImageOp {
    private final double randomX = 256.0 * Math.random();
    private final double randomY = 256.0 * Math.random();
    private double scale = 15.0;
    private double amount = 1.1;
    private double turbulence = 6.2;
    private double[] tx;
    private double[] ty;

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double d) {
        this.amount = d;
    }

    public double getTurbulence() {
        return this.turbulence;
    }

    public void setTurbulence(double d) {
        this.turbulence = d;
    }

    @Override
    protected synchronized void init() {
        this.tx = new double[256];
        this.ty = new double[256];
        for (int i = 0; i < 256; ++i) {
            double d = Math.PI * 2 * (double)i * this.turbulence / 256.0;
            this.tx[i] = this.amount * Math.sin(d);
            this.ty[i] = this.amount * Math.cos(d);
        }
    }

    @Override
    protected void transform(int n, int n2, double[] dArray) {
        int n3 = this.limitByte((int)(127.0 * (1.0 + PerlinNoise.noise2D((double)n / this.scale + this.randomX, (double)n2 / this.scale + this.randomY))));
        dArray[0] = (double)n + this.tx[n3];
        dArray[1] = (double)n2 + this.ty[n3];
    }

    protected void filter2(int[] nArray, int[] nArray2, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = this.limitByte((int)(127.0 * (1.0 + PerlinNoise.noise2D((double)j / this.scale + this.randomX, (double)i / this.scale + this.randomY))));
                nArray2[j + i * n] = this.limitByte(255) << 24 | this.limitByte(n3) << 16 | this.limitByte(n3) << 8 | this.limitByte(n3);
            }
        }
    }
}

