/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.misc.captcha.google.filter.lib;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public abstract class AbstractImageOp
implements BufferedImageOp {
    public static final int EDGE_ZERO = 0;
    public static final int EDGE_MIRROR = 1;
    public static final int EDGE_CLAMP = 2;
    protected int edgeMode;
    protected RenderingHints hints;

    public int getEdgeMode() {
        return this.edgeMode;
    }

    public void setEdgeMode(int n) {
        this.edgeMode = n;
    }

    protected int getPixel(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        if (n >= 0 && n < n3 && n2 >= 0 && n2 < n4) {
            return nArray[n + n2 * n3];
        }
        if (n5 == 0) {
            return 0;
        }
        if (n5 == 2) {
            if (n < 0) {
                n = 0;
            } else if (n >= n3) {
                n = n3 - 1;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 >= n4) {
                n2 = n4 - 1;
            }
            return nArray[n + n2 * n3];
        }
        if (n < 0) {
            n = -n;
        } else if (n >= n3) {
            n = n3 + n3 - n - 1;
        }
        if (n2 < 0) {
            n2 = -n2;
        } else if (n2 > n4) {
            n2 = n4 = n4 - n2 - 1;
        }
        try {
            return nArray[n + n2 * n3];
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private int linear(int n, int n2, int n3, double d) {
        return (int)Math.floor((double)(n >> n3 & 0xFF) + d * (double)((n2 >> n3 & 0xFF) - (n >> n3 & 0xFF))) << n3;
    }

    private int linear(int n, int n2, double d) {
        int n3 = 0;
        for (int i = 0; i < 4; ++i) {
            n3 += this.linear(n, n2, i * 8, d);
        }
        return n3;
    }

    protected int bilinear(int n, int n2, int n3, int n4, double d, double d2) {
        return this.linear(this.linear(n, n2, d), this.linear(n3, n4, d), d2);
    }

    protected int getPixelBilinear(int[] nArray, double d, double d2, int n, int n2, int n3) {
        int n4 = (int)Math.floor(d);
        int n5 = (int)Math.floor(d2);
        double d3 = d - (double)n4;
        double d4 = d2 - (double)n5;
        int n6 = this.getPixel(nArray, n4, n5, n, n2, n3);
        int n7 = this.getPixel(nArray, n4 + 1, n5, n, n2, n3);
        int n8 = this.getPixel(nArray, n4, n5 + 1, n, n2, n3);
        int n9 = this.getPixel(nArray, n4 + 1, n5 + 1, n, n2, n3);
        return this.bilinear(n6, n7, n8, n9, d3, d4);
    }

    protected int limit(int n, int n2, int n3) {
        if (n < n2) {
            n = n2;
        } else if (n > n3) {
            n = n3;
        }
        return n;
    }

    protected int limitByte(int n) {
        return this.limit(n, 0, 255);
    }

    protected void filter(int[] nArray, int[] nArray2, int n, int n2) {
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        int[] nArray2 = new int[n * n2];
        bufferedImage.getRaster().getDataElements(0, 0, n, n2, nArray);
        this.filter(nArray, nArray2, n, n2);
        bufferedImage2.getRaster().setDataElements(0, 0, n, n2, nArray2);
        return bufferedImage2;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        if (colorModel == null && (colorModel = bufferedImage.getColorModel()) instanceof IndexColorModel) {
            colorModel = ColorModel.getRGBdefault();
        }
        return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), colorModel.isAlphaPremultiplied(), null);
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return bufferedImage.getRaster().getBounds();
    }

    @Override
    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.hints;
    }
}

