/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.misc.captcha;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Objects;
import spring.turbo.util.Asserts;

public final class Captcha
implements Serializable {
    private final String word;
    private final BufferedImage image;

    public Captcha(String string, BufferedImage bufferedImage) {
        Asserts.hasLength((String)string);
        Asserts.notNull((Object)bufferedImage);
        this.word = string;
        this.image = bufferedImage;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Captcha captcha = (Captcha)object;
        return this.word.equals(captcha.word) && this.image.equals(captcha.image);
    }

    public int hashCode() {
        return Objects.hash(this.word, this.image);
    }

    public String getWord() {
        return this.word;
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

