/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datahandling.excel.writer;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.lang.Nullable;
import spring.turbo.io.CloseUtils;
import spring.turbo.util.Asserts;

public final class WorkbookIO {
    private WorkbookIO() {
    }

    public static void write(Workbook workbook, OutputStream outputStream) {
        Asserts.notNull((Object)workbook);
        Asserts.notNull((Object)outputStream);
        try {
            workbook.write(outputStream);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        finally {
            CloseUtils.closeQuietly((Closeable)outputStream);
            CloseUtils.closeQuietly((Closeable)workbook);
        }
    }

    public static void write(Workbook workbook, File file) {
        Asserts.notNull((Object)workbook);
        Asserts.notNull((Object)file);
        try {
            WorkbookIO.createIfNotExists(file);
            WorkbookIO.write(workbook, new FileOutputStream(file));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        finally {
            CloseUtils.closeQuietly((Closeable)workbook);
        }
    }

    public static void write(Workbook workbook, Path path) {
        Asserts.notNull((Object)workbook);
        Asserts.notNull((Object)path);
        WorkbookIO.write(workbook, path.toFile());
    }

    public static Path writeToTempFile(Workbook workbook, @Nullable String string, @Nullable String string2) {
        Asserts.notNull((Object)workbook);
        try {
            Path path = Files.createTempFile(string, string2, new FileAttribute[0]).normalize();
            WorkbookIO.createIfNotExists(path.toFile());
            WorkbookIO.write(workbook, path);
            return path;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private static void createIfNotExists(File file) {
        if (file != null && !file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                throw new UnsupportedOperationException(iOException);
            }
        }
    }
}

