/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datahandling.excel.writer;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.context.ApplicationContext;
import org.springframework.core.OrderComparator;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.NumberUtils;
import spring.turbo.bean.valueobject.ValueObjectGetter;
import spring.turbo.bean.valueobject.ValueObjectUtils;
import spring.turbo.module.datahandling.excel.style.StyleProvider;
import spring.turbo.module.datahandling.excel.writer.PredefinedCellStyleFactories;
import spring.turbo.module.datahandling.excel.writer.SheetMetadata;
import spring.turbo.util.Asserts;
import spring.turbo.util.CollectionUtils;
import spring.turbo.util.InstanceCache;

public final class WorkbookBuilder {
    private static final int MAX_CELL_WIDTH = 65280;
    private final List<SheetMetadata<?>> sheetInfo = new ArrayList();
    private InstanceCache instanceCache = InstanceCache.newInstance();
    private Supplier<Workbook> workbookSupplier = XSSFWorkbook::new;

    private WorkbookBuilder() {
    }

    public static WorkbookBuilder newInstance() {
        return new WorkbookBuilder();
    }

    public static WorkbookBuilder newInstance(Supplier<Workbook> supplier) {
        Asserts.notNull(supplier);
        WorkbookBuilder workbookBuilder = new WorkbookBuilder();
        workbookBuilder.workbookSupplier = supplier;
        return workbookBuilder;
    }

    public WorkbookBuilder applicationContext(@Nullable ApplicationContext applicationContext) {
        this.instanceCache = InstanceCache.newInstance((ApplicationContext)applicationContext);
        return this;
    }

    public <T> WorkbookBuilder sheet(Class<T> clazz, int n, String string, @Nullable Collection<T> collection) {
        return this.sheet(clazz, n, string, collection, Collections.emptySet());
    }

    public <T> WorkbookBuilder sheet(Class<T> clazz, int n, String string, @Nullable Collection<T> collection, @Nullable Set<String> set) {
        this.sheetInfo.add(SheetMetadata.newInstance(clazz, n, string, collection, set));
        return this;
    }

    public Workbook build() {
        OrderComparator.sort(this.sheetInfo);
        Workbook workbook = Optional.ofNullable(this.workbookSupplier.get()).orElseGet(XSSFWorkbook::new);
        for (SheetMetadata<?> sheetMetadata : this.sheetInfo) {
            String string = sheetMetadata.getSheetName();
            Sheet sheet = workbook.createSheet(string);
            this.writeSheets(workbook, sheet, sheetMetadata);
        }
        return workbook;
    }

    private void writeSheets(Workbook workbook, Sheet sheet, SheetMetadata<?> sheetMetadata) {
        int n = sheetMetadata.getOffset();
        List<String> list = sheetMetadata.getHeader();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (sheetMetadata.shouldSkip(string)) continue;
            arrayList.add(string);
        }
        this.doWriteHeader(workbook, sheet, arrayList, n, this.getHeaderStyle(this.instanceCache, workbook, sheetMetadata));
        this.doWriteData(workbook, sheet, sheetMetadata.getData(), arrayList, n, this.getCommonDataStyle(this.instanceCache, workbook, sheetMetadata), this.getDateTypeDataStyle(this.instanceCache, workbook, sheetMetadata), sheetMetadata.getValueObjectType());
        this.autoSizeColumns(workbook);
    }

    private void autoSizeColumns(Workbook workbook) {
        int n = workbook.getNumberOfSheets();
        for (int i = 0; i < n; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            if (sheet.getPhysicalNumberOfRows() <= 0) continue;
            Row row = sheet.getRow(sheet.getFirstRowNum());
            Iterator iterator = row.cellIterator();
            while (iterator.hasNext()) {
                Cell cell = (Cell)iterator.next();
                int n2 = cell.getColumnIndex();
                sheet.autoSizeColumn(n2);
                int n3 = sheet.getColumnWidth(n2);
                sheet.setColumnWidth(n2, Math.min(n3 + 2500, 65280));
            }
        }
    }

    @NonNull
    private CellStyle getHeaderStyle(InstanceCache instanceCache, Workbook workbook, SheetMetadata<?> sheetMetadata) {
        CellStyle cellStyle = null;
        StyleProvider styleProvider = sheetMetadata.getHeaderStyleProvider(instanceCache);
        if (styleProvider != null) {
            cellStyle = styleProvider.getStyle(workbook);
        }
        if (cellStyle == null) {
            cellStyle = PredefinedCellStyleFactories.createCellStyleForHeader(workbook);
        }
        return cellStyle;
    }

    @NonNull
    private CellStyle getCommonDataStyle(InstanceCache instanceCache, Workbook workbook, SheetMetadata<?> sheetMetadata) {
        CellStyle cellStyle = null;
        StyleProvider styleProvider = sheetMetadata.getHeaderStyleProvider(instanceCache);
        if (styleProvider != null) {
            cellStyle = styleProvider.getStyle(workbook);
        }
        if (cellStyle == null) {
            cellStyle = PredefinedCellStyleFactories.createCellStyleForCommonData(workbook);
        }
        return cellStyle;
    }

    @NonNull
    private CellStyle getDateTypeDataStyle(InstanceCache instanceCache, Workbook workbook, SheetMetadata<?> sheetMetadata) {
        CellStyle cellStyle = null;
        StyleProvider styleProvider = sheetMetadata.getHeaderStyleProvider(instanceCache);
        if (styleProvider != null) {
            cellStyle = styleProvider.getStyle(workbook);
        }
        if (cellStyle == null) {
            cellStyle = PredefinedCellStyleFactories.createCellStyleForDateTypeData(workbook);
        }
        return cellStyle;
    }

    private void doWriteHeader(Workbook workbook, Sheet sheet, List<String> list, int n, @Nullable CellStyle cellStyle) {
        cellStyle = Optional.ofNullable(cellStyle).orElse(PredefinedCellStyleFactories.createCellStyleForHeader(workbook));
        Row row = sheet.createRow(0);
        for (int i = 0; i < list.size(); ++i) {
            Cell cell = row.createCell(i + n);
            cell.setCellValue(list.get(i));
            cell.setCellStyle(cellStyle);
        }
    }

    private void doWriteData(Workbook workbook, Sheet sheet, Collection<?> collection, List<String> list, int n, @Nullable CellStyle cellStyle, @Nullable CellStyle cellStyle2, Class<?> clazz) {
        if (CollectionUtils.isEmpty(collection)) {
            return;
        }
        Map map = ValueObjectUtils.getAliases(clazz);
        cellStyle = Optional.ofNullable(cellStyle).orElse(PredefinedCellStyleFactories.createCellStyleForCommonData(workbook));
        int n2 = -1;
        for (Object obj : collection) {
            int n3 = ++n2 + 1;
            ValueObjectGetter valueObjectGetter = new ValueObjectGetter(obj);
            Row row = sheet.createRow(n3);
            int n4 = n - 1;
            for (String string : list) {
                Cell cell = row.createCell(++n4);
                Object object = this.getPropertyValue(map, valueObjectGetter, string);
                if (object == null) {
                    cell.setBlank();
                    cell.setCellStyle(cellStyle);
                    continue;
                }
                if (object instanceof Date) {
                    cell.setCellValue((Date)object);
                    cell.setCellStyle(cellStyle2);
                    continue;
                }
                if (object instanceof Calendar) {
                    cell.setCellValue((Calendar)object);
                    cell.setCellStyle(cellStyle2);
                    continue;
                }
                if (object instanceof LocalDateTime) {
                    cell.setCellValue((LocalDateTime)object);
                    cell.setCellStyle(cellStyle);
                    continue;
                }
                if (object instanceof LocalDate) {
                    cell.setCellValue((LocalDate)object);
                    cell.setCellStyle(cellStyle);
                    continue;
                }
                if (object instanceof Number) {
                    cell.setCellValue(((Double)NumberUtils.convertNumberToTargetClass((Number)((Number)object), Double.class)).doubleValue());
                    cell.setCellStyle(cellStyle);
                    continue;
                }
                cell.setCellValue(object.toString());
                cell.setCellStyle(cellStyle);
            }
        }
    }

    @Nullable
    private Object getPropertyValue(Map<String, String> map, ValueObjectGetter valueObjectGetter, String string) {
        String string2 = map.get(string);
        if (string2 == null) {
            return null;
        }
        return valueObjectGetter.get(string2);
    }
}

