/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datahandling.excel.util;

import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import spring.turbo.util.Asserts;

public final class SheetUtils {
    private SheetUtils() {
    }

    public static String getName(Sheet sheet) {
        Asserts.notNull((Object)sheet);
        return sheet.getSheetName();
    }

    public static int getIndex(Sheet sheet) {
        Asserts.notNull((Object)sheet);
        return sheet.getWorkbook().getSheetIndex(sheet);
    }

    public static boolean isHidden(Sheet sheet) {
        Asserts.notNull((Object)sheet);
        return sheet.getWorkbook().isSheetHidden(SheetUtils.getIndex(sheet));
    }

    public static boolean isVisitable(Sheet sheet) {
        Asserts.notNull((Object)sheet);
        return !SheetUtils.isHidden(sheet);
    }

    public static Workbook getParent(Sheet sheet) {
        Asserts.notNull((Object)sheet);
        return sheet.getWorkbook();
    }
}

