/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datahandling.excel.util;

import java.util.Objects;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import spring.turbo.bean.Tuple;
import spring.turbo.module.datahandling.excel.cellparser.CellParser;
import spring.turbo.module.datahandling.excel.cellparser.DefaultCellParser;
import spring.turbo.util.Asserts;

public final class CellUtils {
    private static final CellParser PARSER = new DefaultCellParser();

    private CellUtils() {
    }

    public static Tuple<Workbook, Sheet, Row> getParent(Cell cell) {
        Asserts.notNull((Object)cell);
        Row row = cell.getRow();
        Sheet sheet = row.getSheet();
        Workbook workbook = sheet.getWorkbook();
        return Tuple.ofNullable((Object)workbook, (Object)sheet, (Object)row);
    }

    public static String toString(Cell cell) {
        Asserts.notNull((Object)cell);
        return Objects.requireNonNull(PARSER.convert(cell));
    }
}

