/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datahandling.excel.reader;

import java.io.Closeable;
import java.io.Serializable;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.lang.Nullable;
import spring.turbo.io.CloseUtils;
import spring.turbo.util.Asserts;

public final class WorkbookAndFileSystem
implements Closeable,
Serializable {
    private final Workbook workbook;
    private final POIFSFileSystem fileSystem;

    public WorkbookAndFileSystem(Workbook workbook) {
        this(workbook, null);
    }

    public WorkbookAndFileSystem(Workbook workbook, @Nullable POIFSFileSystem pOIFSFileSystem) {
        Asserts.notNull((Object)workbook);
        this.workbook = workbook;
        this.fileSystem = pOIFSFileSystem;
    }

    @Override
    public void close() {
        CloseUtils.closeQuietly((Closeable)this.workbook);
        CloseUtils.closeQuietly((Closeable)this.fileSystem);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public POIFSFileSystem getFileSystem() {
        return this.fileSystem;
    }
}

