/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datahandling.excel.reader;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import spring.turbo.io.CloseUtils;
import spring.turbo.module.datahandling.excel.ExcelType;
import spring.turbo.module.datahandling.excel.cellparser.CellParser;
import spring.turbo.module.datahandling.excel.cellparser.DefaultCellParser;
import spring.turbo.module.datahandling.excel.function.RowPredicate;
import spring.turbo.module.datahandling.excel.function.RowPredicateFactories;
import spring.turbo.module.datahandling.excel.reader.WorkbookAndFileSystem;
import spring.turbo.module.datahandling.excel.reader.WorkbookResourceUtils;
import spring.turbo.util.Asserts;

public class OneColumnReaders {
    private static final int DEFAULT_BATCH_SIZE = 1024;
    private static final CellParser CELL_PARSER = new DefaultCellParser();

    private OneColumnReaders() {
    }

    public static List<String> read(@NonNull Resource resource, @NonNull ExcelType excelType, @Nullable String string, int n, int n2) {
        return OneColumnReaders.read(resource, excelType, string, n, n2, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> read(@NonNull Resource resource, @NonNull ExcelType excelType, @Nullable String string, int n, int n2, @Nullable Set<Integer> set) {
        ArrayList<String> arrayList;
        Asserts.notNull((Object)resource);
        Asserts.notNull((Object)((Object)excelType));
        ArrayList<String> arrayList2 = new ArrayList<String>(1024);
        WorkbookAndFileSystem workbookAndFileSystem = null;
        RowPredicate rowPredicate = OneColumnReaders.getRowPredicate(n, set);
        try {
            workbookAndFileSystem = WorkbookResourceUtils.createWorkbook(excelType, resource, string);
            Workbook workbook = workbookAndFileSystem.getWorkbook();
            Sheet sheet = OneColumnReaders.getSheet(workbook, n);
            if (sheet != null) {
                for (Row row : sheet) {
                    Cell cell;
                    if (rowPredicate.test(sheet, row) || (cell = row.getCell(n2)) == null) continue;
                    arrayList2.add(CELL_PARSER.convert(cell));
                }
            }
            CloseUtils.closeQuietly((Closeable)workbookAndFileSystem);
            CloseUtils.closeQuietly((Resource)resource);
            arrayList = arrayList2;
        }
        catch (IOException iOException) {
            try {
                throw new UncheckedIOException(iOException);
                catch (GeneralSecurityException generalSecurityException) {
                    throw new IllegalArgumentException(generalSecurityException.getMessage(), generalSecurityException);
                }
            }
            catch (Throwable throwable) {
                CloseUtils.closeQuietly(workbookAndFileSystem);
                throw throwable;
            }
        }
        CloseUtils.closeQuietly((Closeable)workbookAndFileSystem);
        return arrayList;
    }

    private static RowPredicate getRowPredicate(int n, Set<Integer> set) {
        if (CollectionUtils.isEmpty(set)) {
            return RowPredicateFactories.alwaysFalse();
        }
        return RowPredicateFactories.indexInSet(n, set.toArray(new Integer[0]));
    }

    @Nullable
    private static Sheet getSheet(Workbook workbook, int n) {
        try {
            return workbook.getSheetAt(n);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

