/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datahandling.excel.reader;

import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import spring.turbo.bean.Pair;
import spring.turbo.bean.Tuple;
import spring.turbo.bean.valueobject.Batch;
import spring.turbo.bean.valueobject.DataBinding;
import spring.turbo.bean.valueobject.NamedArray;
import spring.turbo.bean.valueobject.NullValidator;
import spring.turbo.bean.valueobject.ProcessPayload;
import spring.turbo.bean.valueobject.ValueObjectFilter;
import spring.turbo.bean.valueobject.ValueObjectUtils;
import spring.turbo.io.CloseUtils;
import spring.turbo.module.datahandling.excel.AbortException;
import spring.turbo.module.datahandling.excel.ExcelType;
import spring.turbo.module.datahandling.excel.cellparser.CellParser;
import spring.turbo.module.datahandling.excel.cellparser.DefaultCellParser;
import spring.turbo.module.datahandling.excel.cellparser.GlobalCellParser;
import spring.turbo.module.datahandling.excel.config.AliasConfig;
import spring.turbo.module.datahandling.excel.config.HeaderConfig;
import spring.turbo.module.datahandling.excel.config.HeaderInfo;
import spring.turbo.module.datahandling.excel.function.RowPredicate;
import spring.turbo.module.datahandling.excel.function.RowPredicateFactories;
import spring.turbo.module.datahandling.excel.function.SheetPredicate;
import spring.turbo.module.datahandling.excel.function.SheetPredicateFactories;
import spring.turbo.module.datahandling.excel.reader.ExitPolicy;
import spring.turbo.module.datahandling.excel.reader.ProcessingResult;
import spring.turbo.module.datahandling.excel.reader.WorkbookAndFileSystem;
import spring.turbo.module.datahandling.excel.reader.WorkbookResourceUtils;
import spring.turbo.module.datahandling.excel.util.RowUtils;
import spring.turbo.module.datahandling.excel.util.SheetUtils;
import spring.turbo.module.datahandling.excel.visitor.BatchVisitor;
import spring.turbo.module.datahandling.excel.visitor.NullBatchVisitor;
import spring.turbo.module.datahandling.excel.visitor.ProcessingContext;
import spring.turbo.util.ArrayUtils;
import spring.turbo.util.Asserts;
import spring.turbo.util.InstanceUtils;
import spring.turbo.util.ReflectionObjectSupplier;
import spring.turbo.util.StringUtils;

public final class BatchWalker<T> {
    private final Map<Integer, HeaderInfo> headerInfoMap = new HashMap<Integer, HeaderInfo>();
    private ProcessPayload payload;
    private Resource resource;
    private ExcelType excelType;
    private String password;
    private Batch<T> dataBatch;
    private BatchVisitor<T> visitor;
    private Supplier<T> valueObjectSupplier;
    private ConversionService conversionService;
    private List<Validator> validators;
    private SheetPredicate includeSheetPredicate;
    private RowPredicate excludeRowPredicate;
    private GlobalCellParser globalCellParser;
    private List<Tuple<Integer, Integer, CellParser>> cellParsers;
    private HeaderConfig headerConfig;
    private AliasConfig aliasConfig;
    private ValueObjectFilter<T> valueObjectFilter;

    private BatchWalker() {
    }

    public static <T> Builder<T> builder(Class<T> clazz) {
        return new Builder<T>(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult walk() {
        Workbook workbook;
        WorkbookAndFileSystem workbookAndFileSystem;
        try {
            workbookAndFileSystem = WorkbookResourceUtils.createWorkbook(this.excelType, this.resource, this.password);
            workbook = workbookAndFileSystem.getWorkbook();
        }
        catch (Exception exception) {
            this.visitor.onResourceOpeningError(this.resource, this.excelType, this.password, this.payload);
            CloseUtils.closeQuietly((Resource)this.resource);
            return ProcessingResult.RESOURCE_ERROR;
        }
        this.initHeaderInfo(workbook);
        try {
            this.doWalk(workbook);
            ProcessingResult processingResult = ProcessingResult.NORMAL;
            return processingResult;
        }
        catch (AbortException abortException) {
            this.visitor.onAbort(this.payload);
            ProcessingResult processingResult = ProcessingResult.ABORTED;
            return processingResult;
        }
        catch (Throwable throwable) {
            this.visitor.onError(new ProcessingContext(this.resource, workbook, null, null), this.payload, throwable);
            ProcessingResult processingResult = ProcessingResult.ABORTED;
            return processingResult;
        }
        finally {
            CloseUtils.closeQuietly((Closeable)workbookAndFileSystem);
            CloseUtils.closeQuietly((Resource)this.resource);
        }
    }

    private void doWalk(Workbook workbook) throws AbortException {
        this.visitor.beforeProcessing(new ProcessingContext(this.resource, workbook, null, null), this.payload);
        for (Sheet sheet : workbook) {
            block17: {
                int n = SheetUtils.getIndex(sheet);
                if (this.includeSheetPredicate.test(sheet) && this.headerInfoMap.containsKey(n)) {
                    if (this.visitor.shouldAbort(this.payload)) {
                        throw new AbortException();
                    }
                    HeaderInfo headerInfo = this.headerInfoMap.get(n);
                    String[] stringArray = headerInfo.getData();
                    for (Row row : sheet) {
                        Object[] objectArray;
                        if (this.visitor.shouldAbort(this.payload)) {
                            throw new AbortException();
                        }
                        int n2 = RowUtils.getIndex(row);
                        if (this.excludeRowPredicate.test(sheet, row) || n2 <= headerInfo.getRowIndex() && n == headerInfo.getSheetIndex() || ArrayUtils.doseNotContainsAnyElements((Object[])(objectArray = this.getRowData(row, stringArray.length, headerInfo.getFirstCellIndex())))) continue;
                        T t = this.valueObjectSupplier.get();
                        BindingResult bindingResult = DataBinding.newInstance().valueObject(t).conversionService(this.conversionService).validators(this.validators.toArray(new Validator[0])).data(NamedArray.builder().addNames(stringArray).addObjects(objectArray).build()).bind();
                        if (this.valueObjectFilter != null && !this.valueObjectFilter.test(t)) continue;
                        if (bindingResult.hasErrors()) {
                            this.payload.incrInvalidDataCount();
                            try {
                                this.visitor.onInvalidValueObject(new ProcessingContext(this.resource, workbook, sheet, row), this.payload, t, bindingResult);
                                continue;
                            }
                            catch (Throwable throwable) {
                                if (throwable instanceof AbortException) {
                                    throw throwable;
                                }
                                this.payload.incrErrorCount();
                                if (ExitPolicy.ABORT != this.onErrorSafe(new ProcessingContext(this.resource, workbook, sheet, null), this.payload, throwable)) continue;
                                throw new AbortException();
                            }
                        }
                        this.payload.incrSuccessCount();
                        if (this.dataBatch.isFull()) {
                            block16: {
                                try {
                                    this.visitor.onValidValueObject(new ProcessingContext(this.resource, workbook, sheet, null), this.payload, this.dataBatch);
                                }
                                catch (Throwable throwable) {
                                    if (throwable instanceof AbortException) {
                                        throw throwable;
                                    }
                                    this.payload.incrErrorCount();
                                    if (ExitPolicy.ABORT != this.onErrorSafe(new ProcessingContext(this.resource, workbook, sheet, null), this.payload, throwable)) break block16;
                                    throw new AbortException();
                                }
                            }
                            this.dataBatch.clear();
                        }
                        this.dataBatch.add(t);
                    }
                }
                if (!this.dataBatch.isNotEmpty()) continue;
                try {
                    this.visitor.onValidValueObject(new ProcessingContext(this.resource, workbook, sheet, null), this.payload, this.dataBatch);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof AbortException) {
                        throw throwable;
                    }
                    this.payload.incrErrorCount();
                    if (ExitPolicy.ABORT != this.onErrorSafe(new ProcessingContext(this.resource, workbook, sheet, null), this.payload, throwable)) break block17;
                    throw new AbortException();
                }
            }
            this.dataBatch.clear();
        }
        this.visitor.afterProcessed(this.payload);
    }

    private ExitPolicy onErrorSafe(ProcessingContext processingContext, ProcessPayload processPayload, Throwable throwable) {
        try {
            return this.visitor.onError(processingContext, processPayload, throwable);
        }
        catch (Throwable throwable2) {
            return ExitPolicy.ABORT;
        }
    }

    private String[] getRowData(Row row, int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = n2; i < n + n2; ++i) {
            Cell cell = row.getCell(i);
            if (cell != null) {
                arrayList.add(this.getEffCellParser(SheetUtils.getIndex(cell.getSheet()), cell.getColumnIndex()).convert(cell));
                continue;
            }
            arrayList.add(null);
        }
        return arrayList.toArray(new String[0]);
    }

    private CellParser getEffCellParser(int n, int n2) {
        for (Tuple<Integer, Integer, CellParser> tuple : this.cellParsers) {
            if ((Integer)tuple.getA() != n || (Integer)tuple.getB() != n2) continue;
            return (CellParser)tuple.getC();
        }
        return this.globalCellParser;
    }

    private void initHeaderInfo(Workbook workbook) {
        Object object;
        Serializable serializable;
        Sheet sheet;
        Sheet sheet2;
        int n;
        for (Tuple<Integer, Integer, String[]> tuple : this.headerConfig.getSheetIndexFixedHeader()) {
            int n2 = (Integer)tuple.getA();
            n = (Integer)tuple.getB();
            sheet2 = (Sheet)tuple.getC();
            try {
                sheet = workbook.getSheetAt(n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                sheet = null;
            }
            if (sheet == null) continue;
            HeaderInfo headerInfo = new HeaderInfo();
            headerInfo.setSheetName(sheet.getSheetName());
            headerInfo.setSheetIndex(n2);
            headerInfo.setRowIndex(-1);
            headerInfo.setFirstCellIndex(n);
            headerInfo.setData(this.replaceWithAlias((String[])sheet2));
            this.headerInfoMap.put(SheetUtils.getIndex(sheet), headerInfo);
        }
        for (Tuple tuple : this.headerConfig.getSheetNameFixedHeader()) {
            String string = (String)tuple.getA();
            n = (Integer)tuple.getB();
            sheet2 = (String[])tuple.getC();
            sheet = workbook.getSheet(string);
            if (sheet == null) continue;
            int n3 = workbook.getSheetIndex(sheet);
            serializable = new HeaderInfo();
            ((HeaderInfo)serializable).setSheetName(string);
            ((HeaderInfo)serializable).setSheetIndex(n3);
            ((HeaderInfo)serializable).setRowIndex(-1);
            ((HeaderInfo)serializable).setFirstCellIndex(n);
            ((HeaderInfo)serializable).setData(this.replaceWithAlias((String[])sheet2));
            this.headerInfoMap.put(SheetUtils.getIndex(sheet), (HeaderInfo)serializable);
        }
        for (Pair pair : this.headerConfig.getSheetIndexConfig()) {
            int n4 = (Integer)pair.getA();
            n = (Integer)pair.getB();
            try {
                sheet2 = workbook.getSheetAt(n4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                sheet2 = null;
            }
            if (sheet2 == null || (sheet = sheet2.getRow(n)) == null) continue;
            short s = sheet.getFirstCellNum();
            serializable = new ArrayList();
            for (Cell cell : sheet) {
                serializable.add(this.globalCellParser.convert(cell));
            }
            object = new HeaderInfo();
            ((HeaderInfo)object).setSheetName(sheet2.getSheetName());
            ((HeaderInfo)object).setSheetIndex(n4);
            ((HeaderInfo)object).setRowIndex(n);
            ((HeaderInfo)object).setFirstCellIndex(s);
            ((HeaderInfo)object).setData(this.replaceWithAlias(serializable.toArray(new String[0])));
            this.headerInfoMap.put(SheetUtils.getIndex(sheet2), (HeaderInfo)object);
        }
        for (Pair pair : this.headerConfig.getSheetNameConfig()) {
            String string = (String)pair.getA();
            n = (Integer)pair.getB();
            sheet2 = workbook.getSheet(string);
            if (sheet2 == null || (sheet = sheet2.getRow(n)) == null) continue;
            short s = sheet.getFirstCellNum();
            serializable = new ArrayList();
            for (Cell cell : sheet) {
                serializable.add(this.globalCellParser.convert(cell));
            }
            object = new HeaderInfo();
            ((HeaderInfo)object).setSheetName(string);
            ((HeaderInfo)object).setSheetIndex(workbook.getSheetIndex(sheet2));
            ((HeaderInfo)object).setRowIndex(n);
            ((HeaderInfo)object).setFirstCellIndex(s);
            ((HeaderInfo)object).setData(this.replaceWithAlias(serializable.toArray(new String[0])));
            this.headerInfoMap.put(SheetUtils.getIndex(sheet2), (HeaderInfo)object);
        }
    }

    private String[] replaceWithAlias(String[] stringArray) {
        if (this.aliasConfig == null) {
            return stringArray;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.aliasConfig.getOrDefault(stringArray[i], stringArray[i]);
        }
        return stringArray;
    }

    public static final class Builder<T> {
        private final Class<T> valueObjectType;
        private final Supplier<T> valueObjectSupplier;
        private final AliasConfig aliasConfig = AliasConfig.newInstance();
        private final HeaderConfig headerConfig = HeaderConfig.newInstance();
        private final List<SheetPredicate> includeSheetPredicates = new LinkedList<SheetPredicate>();
        private final List<RowPredicate> excludeSheetPredicates = new LinkedList<RowPredicate>();
        private final List<Tuple<Integer, Integer, CellParser>> cellParsers = new LinkedList<Tuple<Integer, Integer, CellParser>>();
        private final List<Validator> validators = new LinkedList<Validator>();
        private BatchVisitor<T> visitor;
        private ProcessPayload payload;
        private int batchSize = 1000;
        private ExcelType excelType;
        private Resource resource;
        private String password;
        private GlobalCellParser globalCellParser;
        private ConversionService conversionService;
        private ValueObjectFilter<T> valueObjectFilter;

        private Builder(Class<T> clazz) {
            Asserts.notNull(clazz);
            this.valueObjectType = clazz;
            this.valueObjectSupplier = new ReflectionObjectSupplier(clazz);
        }

        public Builder<T> batchSize(int n) {
            this.batchSize = n;
            return this;
        }

        public Builder<T> payload(ProcessPayload processPayload) {
            this.payload = processPayload;
            return this;
        }

        public Builder<T> setAlias(String string, String string2) {
            this.aliasConfig.add(string, string2);
            return this;
        }

        public Builder<T> setHeader(int n, int n2) {
            this.headerConfig.bySheetIndex(n, n2);
            return this;
        }

        public Builder<T> setFixedHeader(int n, String ... stringArray) {
            this.headerConfig.fixed(n, stringArray);
            return this;
        }

        public Builder<T> setFixedHeader(int n, int n2, String ... stringArray) {
            this.headerConfig.fixed(n, n2, stringArray);
            return this;
        }

        public Builder<T> addIncludeSheet(SheetPredicate ... sheetPredicateArray) {
            if (sheetPredicateArray != null) {
                for (SheetPredicate sheetPredicate : sheetPredicateArray) {
                    Optional.ofNullable(sheetPredicate).ifPresent(this.includeSheetPredicates::add);
                }
            }
            return this;
        }

        public Builder<T> addExcludeRow(RowPredicate ... rowPredicateArray) {
            if (rowPredicateArray != null) {
                for (RowPredicate rowPredicate : rowPredicateArray) {
                    Optional.ofNullable(rowPredicate).ifPresent(this.excludeSheetPredicates::add);
                }
            }
            return this;
        }

        public Builder<T> visitor(BatchVisitor<T> batchVisitor) {
            this.visitor = batchVisitor;
            return this;
        }

        public Builder<T> visitor(Class<? extends BatchVisitor<T>> clazz) {
            this.visitor = (BatchVisitor)InstanceUtils.newInstanceElseThrow(clazz);
            return this;
        }

        public Builder<T> excelType(ExcelType excelType) {
            this.excelType = excelType;
            return this;
        }

        public Builder<T> resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder<T> resource(File file) {
            this.resource = new FileSystemResource(file);
            return this;
        }

        public Builder<T> resource(Path path) {
            this.resource = new FileSystemResource(path);
            return this;
        }

        public Builder<T> password(String string) {
            this.password = string;
            return this;
        }

        public Builder<T> globalCellParser(GlobalCellParser globalCellParser) {
            this.globalCellParser = globalCellParser;
            return this;
        }

        public Builder<T> setColumnBasedCellParser(int n, int n2, CellParser cellParser) {
            this.cellParsers.add((Tuple<Integer, Integer, CellParser>)Tuple.ofNullable((Object)n, (Object)n2, (Object)cellParser));
            return this;
        }

        public Builder<T> conversionService(ConversionService conversionService) {
            this.conversionService = conversionService;
            return this;
        }

        public Builder<T> setValidators(Validator ... validatorArray) {
            if (validatorArray != null) {
                for (Validator validator : validatorArray) {
                    if (validator == null) continue;
                    this.validators.add(validator);
                }
            }
            return this;
        }

        public Builder<T> valueObjectFilter(ValueObjectFilter<T> valueObjectFilter) {
            this.valueObjectFilter = valueObjectFilter;
            return this;
        }

        public BatchWalker<T> build() {
            this.aliasConfig.putAll(ValueObjectUtils.getAliases(this.valueObjectType));
            BatchWalker batchWalker = new BatchWalker();
            batchWalker.valueObjectSupplier = this.valueObjectSupplier;
            batchWalker.dataBatch = new Batch(this.batchSize);
            batchWalker.payload = Optional.ofNullable(this.payload).orElseGet(ProcessPayload::newInstance);
            batchWalker.excelType = Optional.ofNullable(this.excelType).orElse(ExcelType.XSSF);
            batchWalker.resource = Optional.ofNullable(this.resource).orElseThrow(() -> new NullPointerException("resource not set"));
            batchWalker.password = StringUtils.isEmpty((String)this.password) ? null : this.password;
            batchWalker.headerConfig = this.headerConfig;
            batchWalker.aliasConfig = this.aliasConfig;
            batchWalker.globalCellParser = Optional.ofNullable(this.globalCellParser).orElseGet(DefaultCellParser::new);
            batchWalker.cellParsers = this.cellParsers;
            batchWalker.conversionService = Optional.ofNullable(this.conversionService).orElseGet(DefaultFormattingConversionService::new);
            batchWalker.validators = CollectionUtils.isEmpty(this.validators) ? Collections.singletonList(NullValidator.getInstance()) : this.validators;
            batchWalker.includeSheetPredicate = CollectionUtils.isEmpty(this.includeSheetPredicates) ? SheetPredicateFactories.alwaysTrue() : SheetPredicateFactories.any(this.includeSheetPredicates.toArray(new SheetPredicate[0]));
            batchWalker.excludeRowPredicate = CollectionUtils.isEmpty(this.excludeSheetPredicates) ? RowPredicateFactories.alwaysFalse() : RowPredicateFactories.any(this.excludeSheetPredicates.toArray(new RowPredicate[0]));
            batchWalker.visitor = Optional.ofNullable(this.visitor).orElseGet(NullBatchVisitor::getInstance);
            batchWalker.valueObjectFilter = this.valueObjectFilter;
            return batchWalker;
        }
    }
}

