/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datahandling.excel.cellparser;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.springframework.lang.Nullable;
import spring.turbo.module.datahandling.excel.cellparser.GlobalCellParser;

public class DefaultCellParser
implements GlobalCellParser {
    public static final String DEFAULT_DATE_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private final DateFormat dateFormat;

    public DefaultCellParser() {
        this(DEFAULT_DATE_FORMAT_PATTERN);
    }

    public DefaultCellParser(String string) {
        this.dateFormat = new SimpleDateFormat(string);
    }

    @Override
    @Nullable
    public String convert(@Nullable Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case STRING: 
            case FORMULA: 
            case BOOLEAN: {
                return cell.toString();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return this.dateFormat.format(cell.getDateCellValue());
                }
                return cell.toString();
            }
            case BLANK: 
            case ERROR: {
                return null;
            }
        }
        return null;
    }
}

