/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.datahandling.csv.reader;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.Resource;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.lang.Nullable;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import spring.turbo.bean.valueobject.Batch;
import spring.turbo.bean.valueobject.DataBinding;
import spring.turbo.bean.valueobject.NamedArray;
import spring.turbo.bean.valueobject.NullValidator;
import spring.turbo.bean.valueobject.ProcessPayload;
import spring.turbo.bean.valueobject.ValueObjectFilter;
import spring.turbo.bean.valueobject.ValueObjectUtils;
import spring.turbo.io.CloseUtils;
import spring.turbo.io.LineIterator;
import spring.turbo.io.RichResource;
import spring.turbo.module.datahandling.csv.reader.HeaderConfig;
import spring.turbo.module.datahandling.csv.reader.function.GlobalValueNormalizer;
import spring.turbo.module.datahandling.csv.reader.function.HeaderNormalizer;
import spring.turbo.module.datahandling.csv.reader.function.LinePredicate;
import spring.turbo.module.datahandling.csv.reader.function.LinePredicateFactories;
import spring.turbo.module.datahandling.csv.reader.function.NullHeaderNormalizer;
import spring.turbo.module.datahandling.csv.reader.function.NullValueNormalizer;
import spring.turbo.module.datahandling.csv.reader.function.ValueNormalizer;
import spring.turbo.module.datahandling.csv.vistor.BatchVisitor;
import spring.turbo.module.datahandling.csv.vistor.NullBatchVisitor;
import spring.turbo.module.datahandling.csv.vistor.ProcessingContext;
import spring.turbo.util.ArrayUtils;
import spring.turbo.util.Asserts;
import spring.turbo.util.CharsetPool;
import spring.turbo.util.CollectionUtils;
import spring.turbo.util.ReflectionObjectSupplier;

public final class CSVReader<T> {
    @Nullable
    private Resource resource;
    @Nullable
    private Charset charset;
    @Nullable
    private HeaderConfig headerConfig;
    @Nullable
    private BatchVisitor<T> visitor;
    @Nullable
    private Class<T> valueObjectType;
    @Nullable
    private Supplier<T> valueObjectSupplier;
    @Nullable
    private Batch<T> batch;
    @Nullable
    private ConversionService conversionService;
    @Nullable
    private List<Validator> validators;
    @Nullable
    private LinePredicate skipLinePredicate;
    @Nullable
    private HeaderNormalizer headerNormalizer;
    @Nullable
    private GlobalValueNormalizer globalValueNormalizer;
    private Map<Integer, ValueNormalizer> normalizerMap = new HashMap<Integer, ValueNormalizer>();
    @Nullable
    private ValueObjectFilter<T> valueObjectFilter;
    @Nullable
    private String[] headerInUse;

    private CSVReader() {
    }

    public static <T> Builder<T> builder(Class<T> clazz) {
        return new Builder<T>(clazz);
    }

    public void read() {
        this.read(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(@Nullable ProcessPayload processPayload) {
        Asserts.notNull((Object)this.resource);
        Asserts.notNull((Object)this.charset);
        Optional optional = RichResource.builder().nullSafeAddResources(new Resource[]{this.resource}).build();
        if (optional.isEmpty()) {
            throw new UncheckedIOException(new IOException("cannot open resource"));
        }
        LineIterator lineIterator = ((RichResource)optional.get()).asLineIterator(this.charset);
        try {
            this.doRead(lineIterator, Optional.ofNullable(processPayload).orElseGet(ProcessPayload::newInstance));
        }
        finally {
            CloseUtils.closeQuietly((Closeable)lineIterator);
            CloseUtils.closeQuietly((Resource)this.resource);
        }
    }

    private void doRead(LineIterator lineIterator, ProcessPayload processPayload) {
        Asserts.notNull((Object)lineIterator);
        Asserts.notNull((Object)processPayload);
        Asserts.notNull((Object)this.skipLinePredicate);
        Asserts.notNull(this.valueObjectSupplier);
        Asserts.notNull((Object)this.conversionService);
        Asserts.notNull(this.validators);
        Asserts.notNull(this.batch);
        Asserts.notNull((Object)this.resource);
        Asserts.notNull((Object)this.charset);
        Asserts.notNull(this.visitor);
        Asserts.notNull((Object)this.headerConfig);
        int n = -1;
        while (lineIterator.hasNext()) {
            Object[] objectArray;
            String string = lineIterator.next();
            String[] stringArray = this.getHeader(string, ++n);
            if (this.skipLinePredicate.test(n, string) || !this.headerConfig.isFixed() && this.headerConfig.getIndex() == n || stringArray == null || ArrayUtils.doseNotContainsAnyElements((Object[])(objectArray = this.normalizeValue(string.split(","))))) continue;
            T t = this.valueObjectSupplier.get();
            BindingResult bindingResult = DataBinding.newInstance().valueObject(t).conversionService(this.conversionService).validators(this.validators.toArray(new Validator[0])).data(NamedArray.builder().addNames(stringArray).addObjects(objectArray).build()).bind();
            if (this.valueObjectFilter != null && !this.valueObjectFilter.test(t)) continue;
            if (!bindingResult.hasErrors()) {
                processPayload.incrSuccessCount();
                this.batch.add(t);
                if (!this.batch.isFull()) continue;
                try {
                    this.visitor.onValidValueObject(new ProcessingContext(this.resource), processPayload, this.batch);
                }
                catch (Throwable throwable) {
                    processPayload.incrErrorCount();
                    this.visitor.onError(new ProcessingContext(this.resource), processPayload, throwable);
                }
                this.batch.clear();
                continue;
            }
            processPayload.incrInvalidDataCount();
            try {
                this.visitor.onInvalidValueObject(new ProcessingContext(this.resource), processPayload, t, bindingResult);
            }
            catch (Throwable throwable) {
                processPayload.incrErrorCount();
                this.visitor.onError(new ProcessingContext(this.resource), processPayload, throwable);
            }
        }
        if (this.batch.isNotEmpty()) {
            try {
                this.visitor.onValidValueObject(new ProcessingContext(this.resource), processPayload, this.batch);
            }
            catch (Throwable throwable) {
                processPayload.incrErrorCount();
                this.visitor.onError(new ProcessingContext(this.resource), processPayload, throwable);
            }
            this.batch.clear();
        }
    }

    private String[] normalizeHeader(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (this.headerNormalizer != null) {
                string = this.headerNormalizer.normalize(string);
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    private String[] normalizeValue(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            ValueNormalizer valueNormalizer;
            String string = stringArray[i];
            if (this.globalValueNormalizer != null) {
                string = this.globalValueNormalizer.normalize(string);
            }
            if ((valueNormalizer = this.normalizerMap.get(i)) != null) {
                string = valueNormalizer.normalize(string);
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    @Nullable
    private String[] getHeader(String string, int n) {
        Asserts.notNull((Object)this.headerConfig);
        if (this.headerInUse != null) {
            return this.headerInUse;
        }
        if (this.headerConfig.isFixed()) {
            String[] stringArray = this.headerConfig.getHeader();
            Asserts.notNull((Object)stringArray);
            this.headerInUse = this.mergeWithAlias(this.normalizeHeader(stringArray));
            return this.headerInUse;
        }
        if (n == this.headerConfig.getIndex()) {
            this.headerInUse = this.mergeWithAlias(this.normalizeHeader(string.split(",")));
            return this.headerInUse;
        }
        return null;
    }

    public String[] mergeWithAlias(String[] stringArray) {
        Asserts.notNull(this.valueObjectType);
        Map map = ValueObjectUtils.getAliases(this.valueObjectType);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = (String)map.get(stringArray[i]);
            if (string == null) continue;
            stringArray[i] = string;
        }
        return stringArray;
    }

    public static class Builder<T> {
        private final Class<T> valueObjectType;
        private final List<Validator> validators = new ArrayList<Validator>();
        private final Map<Integer, ValueNormalizer> normalizerMap = new HashMap<Integer, ValueNormalizer>();
        private ConversionService conversionService = new DefaultFormattingConversionService();
        private Resource resource;
        private Charset charset = CharsetPool.UTF_8;
        private BatchVisitor<T> visitor = NullBatchVisitor.getInstance();
        private HeaderConfig headerConfig;
        private int batchSize = 1024;
        private ValueObjectFilter<T> valueObjectFilter;
        private LinePredicate skipLinePredicate = LinePredicateFactories.alwaysFalse();
        private HeaderNormalizer headerNormalizer = NullHeaderNormalizer.getInstance();
        private GlobalValueNormalizer globalValueNormalizer = NullValueNormalizer.getInstance();

        private Builder(Class<T> clazz) {
            this.valueObjectType = clazz;
        }

        public Builder<T> resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder<T> charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder<T> charset(String string) {
            return this.charset(Charset.forName(string));
        }

        public Builder<T> visitor(BatchVisitor<T> batchVisitor) {
            this.visitor = batchVisitor;
            return this;
        }

        public Builder<T> header(int n) {
            this.headerConfig = new HeaderConfig(n);
            return this;
        }

        public Builder<T> header(String[] stringArray) {
            this.headerConfig = new HeaderConfig(stringArray);
            return this;
        }

        public Builder<T> conversionService(ConversionService conversionService) {
            this.conversionService = conversionService;
            return this;
        }

        public Builder<T> validator(Validator ... validatorArray) {
            CollectionUtils.nullSafeAddAll(this.validators, (Object[])validatorArray);
            return this;
        }

        public Builder<T> batchSize(int n) {
            this.batchSize = n;
            return this;
        }

        public Builder<T> valueObjectFilter(ValueObjectFilter<T> valueObjectFilter) {
            this.valueObjectFilter = valueObjectFilter;
            return this;
        }

        public Builder<T> skipLinePredicate(LinePredicate linePredicate) {
            this.skipLinePredicate = linePredicate;
            return this;
        }

        public Builder<T> headerNormalizer(HeaderNormalizer headerNormalizer) {
            this.headerNormalizer = headerNormalizer;
            return this;
        }

        public Builder<T> globalValueNormalizer(GlobalValueNormalizer globalValueNormalizer) {
            this.globalValueNormalizer = globalValueNormalizer;
            return this;
        }

        public Builder<T> addNormalizer(Integer n, ValueNormalizer valueNormalizer) {
            this.normalizerMap.put(n, valueNormalizer);
            return this;
        }

        public CSVReader<T> build() {
            Asserts.notNull(this.valueObjectType);
            Asserts.notNull((Object)this.resource);
            Asserts.notNull((Object)this.charset);
            Asserts.notNull(this.visitor);
            Asserts.notNull((Object)this.headerConfig);
            if (CollectionUtils.isEmpty(this.validators)) {
                this.validators.add((Validator)NullValidator.getInstance());
            }
            CSVReader cSVReader = new CSVReader();
            cSVReader.resource = this.resource;
            cSVReader.charset = this.charset;
            cSVReader.valueObjectType = this.valueObjectType;
            cSVReader.valueObjectSupplier = new ReflectionObjectSupplier(this.valueObjectType);
            cSVReader.headerConfig = this.headerConfig;
            cSVReader.visitor = this.visitor;
            cSVReader.conversionService = this.conversionService;
            cSVReader.validators = this.validators;
            cSVReader.batch = new Batch(this.batchSize);
            cSVReader.valueObjectFilter = this.valueObjectFilter;
            cSVReader.skipLinePredicate = this.skipLinePredicate;
            cSVReader.globalValueNormalizer = this.globalValueNormalizer;
            cSVReader.normalizerMap = this.normalizerMap;
            cSVReader.headerNormalizer = this.headerNormalizer;
            return cSVReader;
        }
    }
}

