/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *    ____             _            _____           _
 *   / ___| _ __  _ __(_)_ __   __ |_   _|   _ _ __| |__   ___
 *   \___ \| '_ \| '__| | '_ \ / _` || || | | | '__| '_ \ / _ \
 *    ___) | |_) | |  | | | | | (_| || || |_| | |  | |_) | (_) |
 *   |____/| .__/|_|  |_|_| |_|\__, ||_| \__,_|_|  |_.__/ \___/
 *         |_|                 |___/   https://github.com/yingzhuo/spring-turbo
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
package spring.turbo.module.datahandling.excel.reader;

import org.springframework.core.io.Resource;
import spring.turbo.bean.valueobject.ProcessPayload;

/**
 * @author 应卓
 * @since 1.0.0
 */
public interface BatchValueObjectReadingTrigger {

    public default ProcessingResult fire(ExcelDiscriminator discriminator, Resource resource) {
        return fire(discriminator, resource, ProcessPayload.newInstance());
    }

    public ProcessingResult fire(ExcelDiscriminator discriminator, Resource resource, ProcessPayload payload);

}
