/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.dataaccessing.zookeeper;

import java.io.Closeable;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import spring.turbo.module.dataaccessing.zookeeper.properties.ZookeeperProps;

public class ZkClientFactory
implements FactoryBean<CuratorFramework>,
InitializingBean,
DisposableBean {
    private final ZookeeperProps zkProps;
    @Nullable
    private CuratorFramework zkCli;

    public ZkClientFactory(ZookeeperProps zookeeperProps) {
        this.zkProps = zookeeperProps;
    }

    @Nullable
    public CuratorFramework getObject() {
        return this.zkCli;
    }

    public void afterPropertiesSet() throws Exception {
        this.zkCli = CuratorFrameworkFactory.builder().connectString(this.zkProps.getConnectString()).namespace(this.zkProps.getNamespace()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(this.zkProps.getBackoffRetryPolicy().getBaseSleepTime(), this.zkProps.getBackoffRetryPolicy().getMaxRetries())).build();
        this.zkCli.start();
        this.zkCli.getZookeeperClient().blockUntilConnectedOrTimedOut();
    }

    @Nullable
    public Class<?> getObjectType() {
        return CuratorFramework.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        CloseableUtils.closeQuietly((Closeable)this.zkCli);
    }
}

