/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.dataaccessing.datasource;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import spring.turbo.aop.AspectUtils;
import spring.turbo.module.dataaccessing.datasource.DataSourceSwitch;
import spring.turbo.module.dataaccessing.datasource.DynamicDataSourceRemote;

@Aspect
@Order(value=-2147483648)
public class DataSourceSwitchingAdvice {
    private static final Logger log = LoggerFactory.getLogger(DataSourceSwitchingAdvice.class);

    @Pointcut(value="@annotation(spring.turbo.module.dataaccessing.datasource.DataSourceSwitch)")
    public void annotationPointcut() {
    }

    @Pointcut(value="execution(@(@spring.turbo.module.dataaccessing.datasource.DataSourceSwitch *) * *(..))")
    public void inheritedAnnotationPointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="annotationPointcut() || inheritedAnnotationPointcut()")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object object;
        DataSourceSwitch dataSourceSwitch = (DataSourceSwitch)AspectUtils.getMethodAnnotation((JoinPoint)proceedingJoinPoint, DataSourceSwitch.class);
        if (dataSourceSwitch != null) {
            object = dataSourceSwitch.value();
            log.info("switch datasource to '{}'", object);
            DynamicDataSourceRemote.setKey((String)object);
        }
        try {
            object = proceedingJoinPoint.proceed();
            return object;
        }
        finally {
            DynamicDataSourceRemote.clear();
        }
    }
}

