/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.configuration.util;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import spring.turbo.module.configuration.env.HoconPropertySourceLoader;
import spring.turbo.util.collection.CollectionUtils;
import spring.turbo.util.io.IOExceptionUtils;

public final class PropertySourceUtils {
    private static final PropertySourceLoader PROPERTIES_FORMAT_LOADER = new PropertiesPropertySourceLoader();
    private static final PropertySourceLoader YAML_FORMAT_LOADER = new YamlPropertySourceLoader();
    private static final PropertySourceLoader HOCON_FORMAT_LOADER = new HoconPropertySourceLoader();

    private PropertySourceUtils() {
    }

    @Nullable
    public static PropertySource<?> loadPropertiesFormat(@Nullable Resource resource, String string) {
        if (resource == null || !resource.exists() || !resource.isReadable()) {
            return null;
        }
        try {
            List list = PROPERTIES_FORMAT_LOADER.load(string, resource);
            if (CollectionUtils.size((Collection)list) == 0) {
                return null;
            }
            if (CollectionUtils.size((Collection)list) == 1) {
                return (PropertySource)list.get(0);
            }
            throw IOExceptionUtils.toUnchecked((String)"multiple document is NOT supported yet.");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    public static PropertySource<?> loadYamlFormat(@Nullable Resource resource, String string) {
        if (resource == null || !resource.exists() || !resource.isReadable()) {
            return null;
        }
        try {
            List list = YAML_FORMAT_LOADER.load(string, resource);
            if (CollectionUtils.size((Collection)list) == 0) {
                return null;
            }
            if (CollectionUtils.size((Collection)list) == 1) {
                return (PropertySource)list.get(0);
            }
            throw IOExceptionUtils.toUnchecked((String)"multiple document is NOT supported yet.");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    public static PropertySource<?> loadHoconFormat(@Nullable Resource resource, String string) {
        if (resource == null || !resource.exists() || !resource.isReadable()) {
            return null;
        }
        try {
            List list = HOCON_FORMAT_LOADER.load(string, resource);
            if (CollectionUtils.size((Collection)list) == 0) {
                return null;
            }
            if (CollectionUtils.size((Collection)list) == 1) {
                return (PropertySource)list.get(0);
            }
            throw IOExceptionUtils.toUnchecked((String)"multiple document is NOT supported yet.");
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

