/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.configuration.env.processor;

import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import spring.turbo.module.configuration.env.processor.AbstractLoadmeEnvironmentPostProcessor;
import spring.turbo.module.configuration.env.processor.LoadmeOption;
import spring.turbo.module.configuration.util.PropertySourceUtils;

public class LoadmeYamlEnvironmentPostProcessor
extends AbstractLoadmeEnvironmentPostProcessor {
    public LoadmeYamlEnvironmentPostProcessor(ConfigurableBootstrapContext configurableBootstrapContext) {
        super(configurableBootstrapContext);
        super.setOrder(-2147483547);
    }

    public void postProcessEnvironment(ConfigurableEnvironment configurableEnvironment, SpringApplication springApplication) {
        LoadmeOption loadmeOption = LoadmeOption.YAML;
        if (super.isNotHandled()) {
            LoadmeOption.ResourcePair resourcePair = loadmeOption.load(springApplication);
            if (resourcePair.nothingToRead()) {
                return;
            }
            MutablePropertySources mutablePropertySources = configurableEnvironment.getPropertySources();
            PropertySource<?> propertySource = PropertySourceUtils.loadYamlFormat(resourcePair.getClasspathResource(), "loadme (classpath)");
            PropertySource<?> propertySource2 = PropertySourceUtils.loadYamlFormat(resourcePair.getApplicationHomeResource(), "loadme (application home)");
            int n = 0;
            if (propertySource2 != null) {
                mutablePropertySources.addLast(propertySource2);
                ++n;
            }
            if (propertySource != null) {
                mutablePropertySources.addLast(propertySource);
                ++n;
            }
            if (n > 0) {
                super.setHandled(loadmeOption);
            }
        }
    }
}

