/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.configuration.env.processor;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import spring.turbo.core.ResourceUtils;
import spring.turbo.util.StringFormatter;
import spring.turbo.util.collection.CollectionUtils;

public enum LoadmeOption {
    PROPERTIES(".properties", ".xml"),
    YAML(".yaml", ".yml"),
    HOCON(".conf");

    private final String[] suffixes;

    private LoadmeOption(String ... stringArray) {
        this.suffixes = stringArray;
    }

    public ResourcePair load(SpringApplication springApplication) {
        Resource resource = this.getClassPathResource();
        Resource resource2 = this.getApplicationHomeResource(springApplication);
        return new ResourcePair(resource, resource2);
    }

    @Nullable
    private Resource getClassPathResource() {
        List<String> list = Arrays.stream(this.suffixes).map(string -> StringFormatter.format((String)"classpath:loadme{}", (Object)string)).toList();
        return ResourceUtils.loadFirstExistsResource(list);
    }

    @Nullable
    private Resource getApplicationHomeResource(SpringApplication springApplication) {
        List<String> list = Arrays.stream(this.suffixes).map(string -> StringFormatter.format((String)"file:{}/loadme{}", (Object[])new Object[]{this.getAppHomeDir(springApplication), string})).toList();
        return ResourceUtils.loadFirstExistsResource(list);
    }

    private String getAppHomeDir(SpringApplication springApplication) {
        List<Class> list = springApplication.getAllSources().stream().filter(object -> object instanceof Class).map(object -> (Class)object).toList();
        File file = CollectionUtils.size(list) == 1 ? new ApplicationHome(list.get(0)).getDir() : new ApplicationHome().getDir();
        return file.toPath().toAbsolutePath().toString();
    }

    public static class ResourcePair {
        @Nullable
        private Resource classpathResource;
        @Nullable
        private Resource applicationHomeResource;

        public boolean nothingToRead() {
            int n = 0;
            if (this.classpathResource != null && this.classpathResource.exists() && this.classpathResource.isReadable()) {
                ++n;
            }
            if (this.applicationHomeResource != null && this.applicationHomeResource.exists() && this.applicationHomeResource.isReadable()) {
                ++n;
            }
            return n == 0;
        }

        @Nullable
        @Generated
        public Resource getClasspathResource() {
            return this.classpathResource;
        }

        @Nullable
        @Generated
        public Resource getApplicationHomeResource() {
            return this.applicationHomeResource;
        }

        @Generated
        public void setClasspathResource(@Nullable Resource resource) {
            this.classpathResource = resource;
        }

        @Generated
        public void setApplicationHomeResource(@Nullable Resource resource) {
            this.applicationHomeResource = resource;
        }

        @Generated
        public ResourcePair() {
        }

        @Generated
        public ResourcePair(@Nullable Resource resource, @Nullable Resource resource2) {
            this.classpathResource = resource;
            this.applicationHomeResource = resource2;
        }
    }
}

