/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.configuration.env;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;

public class HoconPropertySourceLoader
implements PropertySourceLoader {
    public String[] getFileExtensions() {
        return new String[]{"conf"};
    }

    public List<PropertySource<?>> load(String string, Resource resource) throws IOException {
        Config config = ConfigFactory.parseURL((URL)resource.getURL());
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        this.buildFlattenedMap(linkedHashMap, config.root().unwrapped(), null);
        if (linkedHashMap.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new MapPropertySource(string, linkedHashMap));
    }

    private void buildFlattenedMap(Map<String, Object> map, Map<String, Object> map2, @Nullable String string) {
        boolean bl = null != string && !string.trim().isEmpty();
        map2.forEach((string2, object) -> {
            Object object2 = bl ? (string2.startsWith("[") ? string + string2 : string + "." + string2) : string2;
            if (object instanceof Map) {
                Map map2 = (Map)object;
                this.buildFlattenedMap(map, map2, (String)object2);
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                int n = 0;
                for (Object e : collection) {
                    this.buildFlattenedMap(map, Collections.singletonMap("[" + n++ + "]", e), (String)object2);
                }
            } else {
                map.put((String)object2, null == object ? "" : object);
            }
        });
    }
}

