/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.configuration.env;

import java.io.IOException;
import java.util.List;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;
import org.springframework.lang.Nullable;
import spring.turbo.module.configuration.env.EmptyPropertySource;
import spring.turbo.util.StringUtils;
import spring.turbo.util.UUIDUtils;

public abstract class AbstractPropertySourceFactory
implements PropertySourceFactory {
    private final PropertySourceLoader loader;

    public AbstractPropertySourceFactory(PropertySourceLoader propertySourceLoader) {
        this.loader = propertySourceLoader;
    }

    public final PropertySource<?> createPropertySource(@Nullable String string, EncodedResource encodedResource) throws IOException {
        String string2 = this.enforcePropertySourceName(string, encodedResource);
        List list = this.loader.load(string2, encodedResource.getResource());
        if (list.isEmpty()) {
            return EmptyPropertySource.of(string2);
        }
        if (list.size() == 1) {
            return (PropertySource)list.get(0);
        }
        throw new IOException("multiple document is NOT supported yet.");
    }

    private String enforcePropertySourceName(@Nullable String string, EncodedResource encodedResource) {
        if (string == null) {
            string = encodedResource.getResource().getFilename();
        }
        if (StringUtils.isBlank((String)string)) {
            return UUIDUtils.uuid36();
        }
        return string;
    }
}

