/*                 _                                            _ _                           _       _
 *  ___ _ __  _ __(_)_ __   __ _       ___  ___  ___ _   _ _ __(_) |_ _   _       _ __   __ _| |_ ___| |__
 * / __| '_ \| '__| | '_ \ / _` |_____/ __|/ _ \/ __| | | | '__| | __| | | |_____| '_ \ / _` | __/ __| '_ \
 * \__ \ |_) | |  | | | | | (_| |_____\__ \  __/ (__| |_| | |  | | |_| |_| |_____| |_) | (_| | || (__| | | |
 * |___/ .__/|_|  |_|_| |_|\__, |     |___/\___|\___|\__,_|_|  |_|\__|\__, |     | .__/ \__,_|\__\___|_| |_|
 *     |_|                 |___/                                      |___/      |_|
 *
 *  https://github.com/yingzhuo/spring-security-patch
 */
package com.github.yingzhuo.spring.security.jwt.factory;

import com.github.yingzhuo.spring.security.jwt.algorithm.AlgorithmFactory;

import java.util.Objects;
import java.util.function.Function;

/**
 * @author 应卓
 * @since 1.0.0
 */
@FunctionalInterface
public interface JwtTokenFactory extends Function<JwtTokenMetadata, String> {

    public static JwtTokenFactory newInstance(AlgorithmFactory algorithmFactory) {
        return new DefaultJwtTokenFactoryImpl(algorithmFactory);
    }

    public String create(JwtTokenMetadata metadata);

    public default String create(JwtTokenMetadata.Builder builder) {
        return create(Objects.requireNonNull(builder).build());
    }

    @Override
    public default String apply(JwtTokenMetadata metadata) {
        return create(metadata);
    }

}
