/*
 *  ____    _    ____  _   _ _____     ___    _
 * / ___|  / \  |  _ \| \ | |_ _\ \   / / \  | |
 * | |    / _ \ | |_) |  \| || | \ \ / / _ \ | |
 * | |___/ ___ \|  _ <| |\  || |  \ V / ___ \| |___
 * \____/_/   \_\_| \_\_| \_|___|  \_/_/   \_\_____|
 *
 * https://github.com/yingzhuo/carnival
 */
package com.github.yingzhuo.carnival.mvc.autoconfig;

import com.github.yingzhuo.carnival.mvc.filter.VeryFirstServletFilter;
import com.github.yingzhuo.carnival.mvc.support.IpAddressHandlerMethodArgumentResolver;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.Ordered;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.view.BeanNameViewResolver;
import org.springframework.web.util.UrlPathHelper;

import java.util.List;
import java.util.Optional;

/**
 * @author 应卓
 */
@Lazy(false)
@ConditionalOnWebApplication
public class MvcCommonAutoConfig implements WebMvcConfigurer {

    @Autowired(required = false)
    public void config(BeanNameViewResolver resolver) {
        if (resolver != null) {
            resolver.setOrder(Ordered.HIGHEST_PRECEDENCE);
        }
    }

    @Override
    public void configurePathMatch(PathMatchConfigurer configurer) {
        val helper = Optional.ofNullable(configurer.getUrlPathHelper()).orElseGet(UrlPathHelper::new);
        helper.setDefaultEncoding("UTF-8");
        helper.setRemoveSemicolonContent(false);
        configurer.setUrlPathHelper(helper);
    }

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(new IpAddressHandlerMethodArgumentResolver());
    }

    @Bean
    public FilterRegistrationBean<VeryFirstServletFilter> veryFirstServletFilterRegistrationBean() {
        val bean = new FilterRegistrationBean<VeryFirstServletFilter>(new VeryFirstServletFilter());
        bean.setName(VeryFirstServletFilter.class.getSimpleName());
        bean.setOrder(Ordered.HIGHEST_PRECEDENCE);
        bean.addUrlPatterns("/*");
        return bean;
    }

}
