/*
 * Decompiled with CFR 0.152.
 */
package boot.support.commons.exception;

import boot.support.commons.exception.CustomExceptionMessage;
import boot.support.commons.exception.ExceptionCodeAndMessage;
import java.util.Objects;

public class CustomException
extends Exception {
    private static final long serialVersionUID = 3521374388748856221L;
    private int code;
    private String message;

    public static void throwx(int code, String message) throws CustomException {
        throw new CustomException(code, message);
    }

    public static void throwx(ExceptionCodeAndMessage exceptionCodeAndMessage) throws CustomException {
        throw new CustomException(exceptionCodeAndMessage);
    }

    public static void throwx(ExceptionCodeAndMessage exceptionMessage, String message) throws CustomException {
        if (Objects.isNull(message) || Objects.equals(message.trim(), "")) {
            throw new CustomException(exceptionMessage);
        }
        throw new CustomException(exceptionMessage, message);
    }

    public static void throwSystemError() throws CustomException {
        CustomException.throwx(CustomExceptionMessage.SYSTEM_ERROR);
    }

    private CustomException() {
    }

    public CustomException(ExceptionCodeAndMessage exceptionCodeAndMessage) {
        super(exceptionCodeAndMessage.getMessage());
        this.code = exceptionCodeAndMessage.getCode();
        this.message = exceptionCodeAndMessage.getMessage();
    }

    public CustomException(ExceptionCodeAndMessage exceptionCodeAndMessage, String message) {
        super(message);
        this.code = exceptionCodeAndMessage.getCode();
        this.message = message;
    }

    public CustomException(int code, String message) {
        super(message);
        this.code = code;
        this.message = message;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

